/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

class Crafting {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_TOOK = "Took";
    private static final String NBT_TO_EXTRACT = "ToExtract";
    private static final String NBT_ROOT = "Root";
    private ICraftingPattern pattern;
    private NonNullList<ItemStack> took;
    private IStackList<ItemStack> toExtract;
    private boolean root;

    public Crafting(ICraftingPattern pattern, NonNullList<ItemStack> took, IStackList<ItemStack> toExtract, boolean root) {
        this.pattern = pattern;
        this.took = took;
        this.toExtract = toExtract;
        this.root = root;
    }

    public Crafting(INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.world());
        this.toExtract = CraftingTask.readItemStackList(tag.func_150295_c(NBT_TO_EXTRACT, 10));
        this.root = tag.func_74767_n(NBT_ROOT);
        this.took = NonNullList.func_191196_a();
        NBTTagList tookList = tag.func_150295_c(NBT_TOOK, 10);
        for (int i = 0; i < tookList.func_74745_c(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(tookList.func_150305_b(i));
            this.took.add((Object)stack);
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public NonNullList<ItemStack> getTook() {
        return this.took;
    }

    public IStackList<ItemStack> getToExtract() {
        return this.toExtract;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN, (NBTBase)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74782_a(NBT_TO_EXTRACT, (NBTBase)CraftingTask.writeItemStackList(this.toExtract));
        tag.func_74757_a(NBT_ROOT, this.root);
        NBTTagList tookList = new NBTTagList();
        for (ItemStack took : this.took) {
            tookList.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(took));
        }
        tag.func_74782_a(NBT_TOOK, (NBTBase)tookList);
        return tag;
    }
}

