/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageDiskItem
implements IStorageDisk<ItemStack> {
    static final String NBT_VERSION = "Version";
    static final String NBT_CAPACITY = "Capacity";
    static final String NBT_ITEMS = "Items";
    private World world;
    private int capacity;
    private Multimap<Item, ItemStack> stacks = ArrayListMultimap.create();
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public StorageDiskItem(World world, int capacity) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = world;
        this.capacity = capacity;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.stacks.values()) {
            list.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(stack));
        }
        tag.func_74778_a(NBT_VERSION, "1.6.9");
        tag.func_74782_a(NBT_ITEMS, (NBTBase)list);
        tag.func_74768_a(NBT_CAPACITY, this.capacity);
        return tag;
    }

    @Override
    public String getId() {
        return "normal_item";
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (action == Action.PERFORM) {
                    otherStack.func_190917_f(remainingSpace);
                    this.onChanged();
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)(size - remainingSpace));
            }
            if (action == Action.PERFORM) {
                otherStack.func_190917_f(size);
                this.onChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            if (action == Action.PERFORM) {
                this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainingSpace));
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
        }
        if (action == Action.PERFORM) {
            this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            this.onChanged();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.func_190916_E()) {
                size = otherStack.func_190916_E();
            }
            if (action == Action.PERFORM) {
                if (otherStack.func_190916_E() - size == 0) {
                    this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
                } else {
                    otherStack.func_190918_g(size);
                }
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.stacks.values().stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.func_190916_E();
    }

    Multimap<Item, ItemStack> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        API.instance().getStorageDiskManager(this.world).markForSaving();
    }
}

