/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StackListFluid
implements IStackList<FluidStack> {
    private ArrayListMultimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();

    @Override
    public void add(@Nonnull FluidStack stack, int size) {
        if (stack == null || size < 0) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount = (long)otherStack.amount + (long)size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (otherStack.amount += size);
            return;
        }
        FluidStack newStack = stack.copy();
        newStack.amount = size;
        this.stacks.put((Object)stack.getFluid(), (Object)newStack);
    }

    @Override
    public void add(@Nonnull FluidStack stack) {
        this.add(stack, stack.amount);
    }

    @Override
    public boolean remove(@Nonnull FluidStack stack, int size) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            boolean success;
            if (!stack.isFluidEqual(otherStack)) continue;
            otherStack.amount -= size;
            boolean bl = success = otherStack.amount >= 0;
            if (otherStack.amount <= 0) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean remove(@Nonnull FluidStack stack) {
        return this.remove(stack, stack.amount);
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack get(int hash) {
        for (FluidStack stack : this.stacks.values()) {
            if (API.instance().getFluidStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> copy() {
        StackListFluid list = new StackListFluid();
        for (FluidStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.getFluid(), (Object)stack.copy());
        }
        return list;
    }
}

