/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerAmount;
import com.raoulvdberge.refinedstorage.gui.GuiAmountSpecifying;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.network.MessageSlotFilterSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;

public class GuiAmount
extends GuiAmountSpecifying {
    private int containerSlot;
    private ItemStack stack;
    private int maxAmount;

    public GuiAmount(GuiBase parent, EntityPlayer player, int containerSlot, ItemStack stack, int maxAmount) {
        super(parent, new ContainerAmount(player, stack), 172, 99);
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.func_190916_E();
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected String getOkButtonText() {
        return GuiAmount.t("misc.refinedstorage:set", new Object[0]);
    }

    @Override
    protected String getTitle() {
        return GuiAmount.t("gui.refinedstorage:item_amount", new Object[0]);
    }

    @Override
    protected String getTexture() {
        return "gui/crafting_settings.png";
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        Integer amount = Ints.tryParse((String)this.amountField.func_146179_b());
        if (amount != null) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageSlotFilterSet(this.containerSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)amount)));
            this.close();
        }
    }
}

