/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GridStackItem
implements IGridStack {
    private int hash;
    private ItemStack stack;
    private String cachedName;
    private boolean craftable;
    private boolean displayCraftText;
    private String[] oreIds = null;
    @Nullable
    private IStorageTracker.IStorageTrackerEntry entry;

    public GridStackItem(ItemStack stack) {
        this.stack = stack;
    }

    public GridStackItem(ByteBuf buf) {
        this.stack = StackUtils.readItemStack(buf);
        this.hash = buf.readInt();
        this.craftable = buf.readBoolean();
        this.setDisplayCraftText(buf.readBoolean());
        if (buf.readBoolean()) {
            this.entry = new StorageTrackerEntry(buf);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public boolean doesDisplayCraftText() {
        return this.displayCraftText;
    }

    @Override
    public void setDisplayCraftText(boolean displayCraftText) {
        this.displayCraftText = displayCraftText;
        if (displayCraftText) {
            this.stack.func_190920_e(1);
        }
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        try {
            if (this.cachedName == null) {
                this.cachedName = this.stack.func_82833_r();
            }
            return this.cachedName;
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public String getModId() {
        return this.stack.func_77973_b().getCreatorModId(this.stack);
    }

    @Override
    public String[] getOreIds() {
        if (this.oreIds == null) {
            this.oreIds = this.stack.func_190926_b() ? new String[0] : (String[])Arrays.stream(OreDictionary.getOreIDs((ItemStack)this.stack)).mapToObj(OreDictionary::getOreName).toArray(String[]::new);
        }
        return this.oreIds;
    }

    @Override
    public String getTooltip() {
        try {
            return RenderUtils.getItemTooltip(this.stack).stream().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public int getQuantity() {
        return this.doesDisplayCraftText() ? 0 : this.stack.func_190916_E();
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity());
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        String text = null;
        if (this.displayCraftText) {
            text = I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        } else if (this.stack.func_190916_E() > 1) {
            text = API.instance().getQuantityFormatter().formatWithUnits(this.getQuantity());
        }
        gui.drawItem(x, y, this.stack, true, text);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageTracker.IStorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.entry = entry;
    }
}

