/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.registry.CraftingTaskFactory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPattern
implements ICraftingPattern {
    private final ICraftingPatternContainer container;
    private final ItemStack stack;
    private final boolean processing;
    private final boolean exact;
    private final boolean valid;
    @Nullable
    private final ITextComponent errorMessage;
    @Nullable
    private final ICraftingRecipe recipe;
    private final List<NonNullList<ItemStack>> inputs;
    private final NonNullList<ItemStack> outputs;
    private final NonNullList<ItemStack> byproducts;
    private final List<NonNullList<FluidStack>> fluidInputs;
    private final NonNullList<FluidStack> fluidOutputs;
    @Nullable
    private final AllowedTagList allowedTagList;

    public CraftingPattern(ICraftingPatternContainer container, ItemStack stack, boolean processing, boolean exact, @Nullable ITextComponent errorMessage, boolean valid, @Nullable ICraftingRecipe recipe, List<NonNullList<ItemStack>> inputs, NonNullList<ItemStack> outputs, NonNullList<ItemStack> byproducts, List<NonNullList<FluidStack>> fluidInputs, NonNullList<FluidStack> fluidOutputs, @Nullable AllowedTagList allowedTagList) {
        this.container = container;
        this.stack = stack;
        this.processing = processing;
        this.exact = exact;
        this.valid = valid;
        this.errorMessage = errorMessage;
        this.recipe = recipe;
        this.inputs = inputs;
        this.outputs = outputs;
        this.byproducts = byproducts;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
        this.allowedTagList = allowedTagList;
    }

    @Nullable
    public AllowedTagList getAllowedTagList() {
        return this.allowedTagList;
    }

    @Override
    public ICraftingPatternContainer getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    @Nullable
    public ITextComponent getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public List<NonNullList<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public ItemStack getOutput(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get crafting output from processing pattern");
        }
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        DummyCraftingInventory inv = new DummyCraftingInventory();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        ItemStack result = this.recipe.func_77572_b((IInventory)inv);
        if (result.func_190926_b()) {
            throw new IllegalStateException("Cannot have empty result");
        }
        return result;
    }

    @Override
    public NonNullList<ItemStack> getByproducts() {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        return this.byproducts;
    }

    @Override
    public NonNullList<ItemStack> getByproducts(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        DummyCraftingInventory inv = new DummyCraftingInventory();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        NonNullList remainingItems = this.recipe.func_179532_b((IInventory)inv);
        NonNullList sanitized = NonNullList.func_191196_a();
        for (ItemStack item : remainingItems) {
            if (item.func_190926_b()) continue;
            sanitized.add((Object)item);
        }
        return sanitized;
    }

    @Override
    public List<NonNullList<FluidStack>> getFluidInputs() {
        return this.fluidInputs;
    }

    @Override
    public NonNullList<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Override
    public ResourceLocation getId() {
        return CraftingTaskFactory.ID;
    }

    @Override
    public boolean canBeInChainWith(ICraftingPattern other) {
        int j;
        List otherInputs;
        List inputs;
        int i;
        if (other.isProcessing() != this.processing) {
            return false;
        }
        if (other.getInputs().size() != this.inputs.size() || other.getFluidInputs().size() != this.fluidInputs.size() || other.getOutputs().size() != this.outputs.size() || other.getFluidOutputs().size() != this.fluidOutputs.size()) {
            return false;
        }
        if (!this.processing && other.getByproducts().size() != this.byproducts.size()) {
            return false;
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            inputs = (List)this.inputs.get(i);
            otherInputs = (List)other.getInputs().get(i);
            if (inputs.size() != otherInputs.size()) {
                return false;
            }
            for (j = 0; j < inputs.size(); ++j) {
                if (API.instance().getComparer().isEqual((ItemStack)inputs.get(j), (ItemStack)otherInputs.get(j))) continue;
                return false;
            }
        }
        for (i = 0; i < this.fluidInputs.size(); ++i) {
            inputs = (List)this.fluidInputs.get(i);
            otherInputs = (List)other.getFluidInputs().get(i);
            if (inputs.size() != otherInputs.size()) {
                return false;
            }
            for (j = 0; j < inputs.size(); ++j) {
                if (API.instance().getComparer().isEqual((FluidStack)inputs.get(j), (FluidStack)otherInputs.get(j), 3)) continue;
                return false;
            }
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((ItemStack)this.outputs.get(i), (ItemStack)other.getOutputs().get(i))) continue;
            return false;
        }
        for (i = 0; i < this.fluidOutputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((FluidStack)this.fluidOutputs.get(i), (FluidStack)other.getFluidOutputs().get(i), 3)) continue;
            return false;
        }
        if (!this.processing) {
            for (i = 0; i < this.byproducts.size(); ++i) {
                if (API.instance().getComparer().isEqual((ItemStack)this.byproducts.get(i), (ItemStack)other.getByproducts().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getChainHashCode() {
        int result = 0;
        result = 31 * result + (this.processing ? 1 : 0);
        result = 31 * result + (this.exact ? 1 : 0);
        for (List list : this.inputs) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getItemStackHashCode(input);
            }
        }
        for (List list : this.fluidInputs) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getFluidStackHashCode((FluidStack)input);
            }
        }
        for (ItemStack itemStack : this.outputs) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        for (FluidStack fluidStack : this.fluidOutputs) {
            result = 31 * result + API.instance().getFluidStackHashCode(fluidStack);
        }
        for (ItemStack itemStack : this.byproducts) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        return result;
    }

    public static class DummyCraftingInventory
    extends CraftingInventory {
        public DummyCraftingInventory() {
            super(new Container(null, 0){

                public boolean func_75145_c(PlayerEntity player) {
                    return true;
                }
            }, 3, 3);
        }
    }
}

