/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class CraftingMonitorElementList
implements ICraftingMonitorElementList {
    private List<ICraftingMonitorElement> elements = new LinkedList<ICraftingMonitorElement>();
    private Map<ResourceLocation, Map<Integer, ICraftingMonitorElement>> currentLists = new LinkedHashMap<ResourceLocation, Map<Integer, ICraftingMonitorElement>>();

    @Override
    public void directAdd(ICraftingMonitorElement element) {
        this.elements.add(element);
    }

    @Override
    public void add(ICraftingMonitorElement element) {
        ICraftingMonitorElement exitingElement;
        Map<Integer, ICraftingMonitorElement> currentElements = this.currentLists.get(element.getId());
        if (currentElements == null) {
            currentElements = new HashMap<Integer, ICraftingMonitorElement>();
        }
        if ((exitingElement = currentElements.get(element.elementHashCode())) == null) {
            exitingElement = element;
        } else {
            exitingElement.merge(element);
        }
        currentElements.put(exitingElement.elementHashCode(), exitingElement);
        this.currentLists.put(exitingElement.getId(), currentElements);
    }

    @Override
    public void commit() {
        this.currentLists.values().stream().map(Map::values).flatMap(Collection::stream).forEach(this.elements::add);
        this.currentLists.clear();
    }

    @Override
    public List<ICraftingMonitorElement> getElements() {
        if (!this.currentLists.isEmpty()) {
            this.commit();
        }
        return this.elements;
    }
}

