/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.IWirelessTransmitter;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemManager;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemProvider;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NetworkItemManager
implements INetworkItemManager {
    private final INetwork network;
    private final Map<PlayerEntity, INetworkItem> items = new ConcurrentHashMap<PlayerEntity, INetworkItem>();

    public NetworkItemManager(INetwork network) {
        this.network = network;
    }

    @Override
    public void open(PlayerEntity player, ItemStack stack, int slotId) {
        boolean inRange = false;
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            IWirelessTransmitter transmitter;
            double distance;
            if (!(node instanceof IWirelessTransmitter) || !this.network.canRun() || !node.isActive() || ((IWirelessTransmitter)((Object)node)).getDimension() != player.field_71093_bK || !((distance = Math.sqrt(Math.pow((double)(transmitter = (IWirelessTransmitter)((Object)node)).getOrigin().func_177958_n() - player.field_70165_t, 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - player.field_70163_u, 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - player.field_70161_v, 2.0))) < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_item.out_of_range", new Object[0]));
            return;
        }
        INetworkItem item = ((INetworkItemProvider)stack.func_77973_b()).provide(this, player, stack, slotId);
        if (item.onOpen(this.network)) {
            this.items.put(player, item);
        }
    }

    @Override
    public void close(PlayerEntity player) {
        this.items.remove(player);
    }

    @Override
    public INetworkItem getItem(PlayerEntity player) {
        return this.items.get(player);
    }

    @Override
    public void drainEnergy(PlayerEntity player, int energy) {
        INetworkItem item = this.getItem(player);
        if (item != null) {
            item.drainEnergy(energy);
        }
    }
}

