/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.UpgradeItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.UpgradeItem;
import com.raoulvdberge.refinedstorage.tile.ExporterTile;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ExporterNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "exporter");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.STACK).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int type = 0;
    private int filterSlot;

    public ExporterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0) {
            if (this.type == 0) {
                IItemHandler handler = WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
                if (handler != null) {
                    ItemStack slot;
                    while (this.filterSlot + 1 < this.itemFilters.getSlots() && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b()) {
                        ++this.filterSlot;
                    }
                    if (this.filterSlot == this.itemFilters.getSlots() - 1 && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b() || this.filterSlot >= this.itemFilters.getSlots()) {
                        this.filterSlot = 0;
                    }
                    if (!(slot = this.itemFilters.getStackInSlot(this.filterSlot)).func_190926_b()) {
                        int stackSize = this.upgrades.getStackInteractCount();
                        ItemStack took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, Action.SIMULATE);
                        if (took.func_190926_b()) {
                            if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, this.filterSlot), slot, stackSize);
                            }
                        } else if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true).func_190926_b()) {
                            took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, Action.PERFORM);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                        }
                    }
                    ++this.filterSlot;
                }
            } else if (this.type == 1) {
                IFluidHandler handler;
                FluidStack[] fluids = this.fluidFilters.getFluids();
                while (this.filterSlot + 1 < fluids.length && fluids[this.filterSlot] == null) {
                    ++this.filterSlot;
                }
                if (this.filterSlot == fluids.length - 1 && fluids[this.filterSlot] == null || this.filterSlot >= fluids.length) {
                    this.filterSlot = 0;
                }
                if ((handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null) {
                    FluidStack stack = fluids[this.filterSlot];
                    if (stack != null) {
                        int toExtract = 1000 * this.upgrades.getStackInteractCount();
                        FluidStack stackInStorage = this.network.getFluidStorageCache().getList().get(stack, this.compare);
                        if (stackInStorage != null) {
                            FluidStack took = this.network.extractFluid(stack, toExtract = Math.min(toExtract, stackInStorage.getAmount()), this.compare, Action.SIMULATE);
                            int filled = handler.fill(took, IFluidHandler.FluidAction.SIMULATE);
                            if (filled > 0) {
                                took = this.network.extractFluid(stack, filled, this.compare, Action.PERFORM);
                                handler.fill(took, IFluidHandler.FluidAction.EXECUTE);
                            }
                        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                            this.network.getCraftingManager().request((Object)this, stack, toExtract);
                        }
                    }
                    ++this.filterSlot;
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? ExporterTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }
}

