/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCard;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCardContainer;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.security.SecurityCard;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidator;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.SecurityCardItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class SecurityManagerNetworkNode
extends NetworkNode
implements ISecurityCardContainer {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "security_manager");
    private List<ISecurityCard> cards = new ArrayList<ISecurityCard>();
    private ISecurityCard globalCard;
    private BaseItemHandler cardsInv = new BaseItemHandler(18).addValidator(new ItemValidator(RSItems.SECURITY_CARD)).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!this.world.field_72995_K) {
            this.invalidate();
        }
        if (this.network != null) {
            this.network.getSecurityManager().invalidate();
        }
    });
    private BaseItemHandler editCard = new BaseItemHandler(1).addValidator(new ItemValidator(RSItems.SECURITY_CARD)).addListener(new NetworkNodeInventoryListener(this));

    public SecurityManagerNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.SERVER_CONFIG.getSecurityManager().getUsage();
        for (int i = 0; i < this.cardsInv.getSlots(); ++i) {
            if (this.cardsInv.getStackInSlot(i).func_190926_b()) continue;
            usage += RS.SERVER_CONFIG.getSecurityManager().getUsagePerCard();
        }
        return usage;
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.cards.clear();
        this.globalCard = null;
        for (int i = 0; i < this.cardsInv.getSlots(); ++i) {
            ItemStack stack = this.cardsInv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            UUID uuid = SecurityCardItem.getOwner(stack);
            if (uuid == null) {
                this.globalCard = this.createCard(stack, null);
                continue;
            }
            this.cards.add(this.createCard(stack, uuid));
        }
    }

    private ISecurityCard createCard(ItemStack stack, @Nullable UUID uuid) {
        SecurityCard card = new SecurityCard(uuid);
        for (Permission permission : Permission.values()) {
            card.getPermissions().put(permission, SecurityCardItem.hasPermission(stack, permission));
        }
        return card;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.cardsInv, 0, tag);
        StackUtils.readItems(this.editCard, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.cardsInv, 0, tag);
        StackUtils.writeItems((IItemHandler)this.editCard, 1, tag);
        return tag;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getSecurityManager().invalidate();
    }

    public BaseItemHandler getCardsItems() {
        return this.cardsInv;
    }

    public BaseItemHandler getEditCard() {
        return this.editCard;
    }

    public void updatePermission(Permission permission, boolean state) {
        ItemStack card = this.getEditCard().getStackInSlot(0);
        if (!card.func_190926_b()) {
            SecurityCardItem.setPermission(card, permission, state);
        }
    }

    @Override
    public List<ISecurityCard> getCards() {
        return this.cards;
    }

    @Override
    @Nullable
    public ISecurityCard getGlobalCard() {
        return this.globalCard;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.cardsInv, this.editCard});
    }
}

