/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class StorageMonitorNetworkNode
extends NetworkNode
implements IComparable {
    public static final int DEPOSIT_ALL_MAX_DELAY = 500;
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "storage_monitor");
    private static final String NBT_COMPARE = "Compare";
    private BaseItemHandler itemFilter = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!reading) {
            WorldUtils.updateBlock(this.world, this.pos);
        }
    });
    private Map<String, Pair<ItemStack, Long>> deposits = new HashMap<String, Pair<ItemStack, Long>>();
    private int compare = 1;
    private int oldAmount = -1;

    public StorageMonitorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public void update() {
        super.update();
        int newAmount = this.getAmount();
        if (this.oldAmount == -1) {
            this.oldAmount = newAmount;
        } else if (this.oldAmount != newAmount) {
            this.oldAmount = newAmount;
            WorldUtils.updateBlock(this.world, this.pos);
        }
    }

    public boolean depositAll(PlayerEntity player) {
        if (this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        Pair<ItemStack, Long> deposit = this.deposits.get(player.func_146103_bH().getName());
        if (deposit == null) {
            return false;
        }
        ItemStack inserted = (ItemStack)deposit.getKey();
        long insertedAt = (Long)deposit.getValue();
        if (System.currentTimeMillis() - insertedAt < 500L) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack toInsert = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqual(inserted, toInsert, this.compare)) continue;
                player.field_71071_by.func_70299_a(i, this.network.insertItemTracked(toInsert, toInsert.func_190916_E()));
            }
        }
        return true;
    }

    public boolean deposit(PlayerEntity player, ItemStack toInsert) {
        if (this.network == null) {
            return false;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            return false;
        }
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        if (!filter.func_190926_b() && API.instance().getComparer().isEqual(filter, toInsert, this.compare)) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.network.insertItemTracked(toInsert, toInsert.func_190916_E()));
            this.deposits.put(player.func_146103_bH().getName(), (Pair<ItemStack, Long>)Pair.of((Object)toInsert, (Object)System.currentTimeMillis()));
        }
        return true;
    }

    public void extract(PlayerEntity player, Direction side) {
        ItemStack result;
        int toExtract;
        if (this.network == null || this.getDirection() != side) {
            return;
        }
        if (!this.network.getSecurityManager().hasPermission(Permission.EXTRACT, player)) {
            return;
        }
        ItemStack filter = this.itemFilter.getStackInSlot(0);
        int n = toExtract = player.func_70093_af() ? 1 : 64;
        if (!(filter.func_190926_b() || (result = this.network.extractItem(filter, toExtract, this.compare, Action.PERFORM)).func_190926_b() || player.field_71071_by.func_70441_a(result.func_77946_l()))) {
            InventoryHelper.func_180173_a((World)this.world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)result);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getStorageMonitor().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        WorldUtils.updateBlock(this.world, this.pos);
        this.markDirty();
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        StackUtils.writeItems((IItemHandler)this.itemFilter, 0, tag);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        StackUtils.readItems(this.itemFilter, 0, tag);
    }

    public int getAmount() {
        if (this.network == null) {
            return 0;
        }
        ItemStack toCheck = this.itemFilter.getStackInSlot(0);
        if (toCheck.func_190926_b()) {
            return 0;
        }
        ItemStack stored = this.network.getItemStorageCache().getList().get(toCheck, this.compare);
        return stored != null ? stored.func_190916_E() : 0;
    }

    public BaseItemHandler getItemFilters() {
        return this.itemFilter;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }
}

