/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IStorageScreen;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.storage.ItemStorageWrapperStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.ItemStorageType;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.ItemStorageCache;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.tile.StorageTile;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IWhitelistBlacklist;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.StorageBlockUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class StorageNetworkNode
extends NetworkNode
implements IStorageScreen,
IStorageProvider,
IComparable,
IWhitelistBlacklist,
IPrioritizable,
IAccessType,
IStorageDiskContainerContext {
    public static final ResourceLocation ONE_K_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "1k_storage_block");
    public static final ResourceLocation FOUR_K_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "4k_storage_block");
    public static final ResourceLocation SIXTEEN_K_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "16k_storage_block");
    public static final ResourceLocation SIXTY_FOUR_K_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "64k_storage_block");
    public static final ResourceLocation CREATIVE_STORAGE_BLOCK_ID = new ResourceLocation("refinedstorage", "creative_storage_block");
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    public static final String NBT_ID = "Id";
    private BaseItemHandler filters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final ItemStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 1;
    private int mode = 1;
    private UUID storageId = UUID.randomUUID();
    private IStorageDisk<ItemStack> storage;

    public StorageNetworkNode(World world, BlockPos pos, ItemStorageType type) {
        super(world, pos);
        this.type = type;
    }

    @Override
    public int getEnergyUsage() {
        switch (this.type) {
            case ONE_K: {
                return RS.SERVER_CONFIG.getStorageBlock().getOneKUsage();
            }
            case FOUR_K: {
                return RS.SERVER_CONFIG.getStorageBlock().getFourKUsage();
            }
            case SIXTEEN_K: {
                return RS.SERVER_CONFIG.getStorageBlock().getSixteenKUsage();
            }
            case SIXTY_FOUR_K: {
                return RS.SERVER_CONFIG.getStorageBlock().getSixtyFourKUsage();
            }
            case CREATIVE: {
                return RS.SERVER_CONFIG.getStorageBlock().getCreativeUsage();
            }
        }
        return 0;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().runActionWhenPossible(ItemStorageCache.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        if (this.storage == null) {
            this.loadStorage();
        }
        storages.add(this.storage);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
    }

    @Override
    public ResourceLocation getId() {
        return StorageBlockUtils.getNetworkNodeId(this.type);
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_186854_a(NBT_ID, this.storageId);
        return tag;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_186855_b(NBT_ID)) {
            this.storageId = tag.func_186857_a(NBT_ID);
            this.loadStorage();
        }
    }

    public void loadStorage() {
        IStorageDisk<ItemStack> disk = API.instance().getStorageDiskManager((ServerWorld)this.world).get(this.storageId);
        if (disk == null) {
            disk = API.instance().createDefaultItemDisk((ServerWorld)this.world, this.type.getCapacity());
            API.instance().getStorageDiskManager((ServerWorld)this.world).set(this.storageId, disk);
            API.instance().getStorageDiskManager((ServerWorld)this.world).markForSaving();
        }
        this.storage = new ItemStorageWrapperStorageDisk(this, disk);
    }

    public void setStorageId(UUID id) {
        this.storageId = id;
        this.markDirty();
    }

    public UUID getStorageId() {
        return this.storageId;
    }

    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public BaseItemHandler getFilters() {
        return this.filters;
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("block.refinedstorage." + this.type.getName() + "_storage_block", new Object[0]);
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return StorageTile.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return StorageTile.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getWhitelistBlacklistParameter() {
        return StorageTile.WHITELIST_BLACKLIST;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return StorageTile.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return StorageTile.ACCESS_TYPE;
    }

    @Override
    public long getStored() {
        return StorageTile.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return this.type.getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
        }
    }
}

