/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageCache
implements IStorageCache<FluidStack> {
    public static final Consumer<INetwork> INVALIDATE = n -> n.getFluidStorageCache().invalidate();
    private final INetwork network;
    private final CopyOnWriteArrayList<IStorage<FluidStack>> storages = new CopyOnWriteArrayList();
    private final IStackList<FluidStack> list = API.instance().createFluidStackList();
    private final IStackList<FluidStack> craftables = API.instance().createFluidStackList();
    private final List<IStorageCacheListener<FluidStack>> listeners = new LinkedList<IStorageCacheListener<FluidStack>>();
    private final List<StackListResult<FluidStack>> batchedChanges = new ArrayList<StackListResult<FluidStack>>();

    public FluidStorageCache(INetwork network) {
        this.network = network;
    }

    @Override
    public void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.isActive() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addFluidStorages(this.storages));
        this.list.clear();
        this.sort();
        for (IStorage<FluidStack> storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (FluidStack stack : storage.getStacks()) {
                if (stack.isEmpty()) continue;
                this.add(stack, stack.getAmount(), true, false);
            }
        }
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public void add(@Nonnull FluidStack stack, int size, boolean rebuilding, boolean batched) {
        StackListResult<FluidStack> result = this.list.add(stack, size);
        if (!rebuilding) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public void remove(@Nonnull FluidStack stack, int size, boolean batched) {
        StackListResult<FluidStack> result = this.list.remove(stack, size);
        if (result != null) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public void flush() {
        if (!this.batchedChanges.isEmpty()) {
            if (this.batchedChanges.size() > 1) {
                this.listeners.forEach(l -> l.onChangedBulk(this.batchedChanges));
            } else {
                this.batchedChanges.forEach(change -> this.listeners.forEach(l -> l.onChanged(change)));
            }
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<FluidStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<FluidStack> getCraftablesList() {
        return this.craftables;
    }

    @Override
    public List<IStorage<FluidStack>> getStorages() {
        return this.storages;
    }
}

