/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExternalStorageCache {
    private List<FluidStack> cache;

    public void update(INetwork network, @Nullable IFluidHandler handler) {
        int i;
        if (handler == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<FluidStack>();
            for (int i2 = 0; i2 < handler.getTanks(); ++i2) {
                this.cache.add(handler.getFluidInTank(i2));
            }
            return;
        }
        for (i = 0; i < handler.getTanks(); ++i) {
            FluidStack actual = handler.getFluidInTank(i);
            if (i >= this.cache.size()) {
                if (actual.isEmpty()) continue;
                network.getFluidStorageCache().add(actual, actual.getAmount(), false, true);
                this.cache.add(actual.copy());
                continue;
            }
            FluidStack cached = this.cache.get(i);
            if (actual.isEmpty() && cached.isEmpty()) continue;
            if (actual.isEmpty() && !cached.isEmpty()) {
                network.getFluidStorageCache().remove(cached, cached.getAmount(), true);
                this.cache.set(i, FluidStack.EMPTY);
                continue;
            }
            if (!actual.isEmpty() && cached.isEmpty()) {
                network.getFluidStorageCache().add(actual, actual.getAmount(), false, true);
                this.cache.set(i, actual.copy());
                continue;
            }
            if (!API.instance().getComparer().isEqual(actual, cached, 1)) {
                network.getFluidStorageCache().remove(cached, cached.getAmount(), true);
                network.getFluidStorageCache().add(actual, actual.getAmount(), false, true);
                this.cache.set(i, actual.copy());
                continue;
            }
            if (actual.getAmount() > cached.getAmount()) {
                network.getFluidStorageCache().add(actual, actual.getAmount() - cached.getAmount(), false, true);
                cached.setAmount(actual.getAmount());
                continue;
            }
            if (actual.getAmount() >= cached.getAmount()) continue;
            network.getFluidStorageCache().remove(actual, cached.getAmount() - actual.getAmount(), true);
            cached.setAmount(actual.getAmount());
        }
        if (this.cache.size() > handler.getTanks()) {
            for (i = this.cache.size() - 1; i >= handler.getTanks(); --i) {
                FluidStack cached = this.cache.get(i);
                if (!cached.isEmpty()) {
                    network.getFluidStorageCache().remove(cached, cached.getAmount(), true);
                }
                this.cache.remove(i);
            }
        }
        network.getFluidStorageCache().flush();
    }
}

