/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.block.BlockDirection;
import com.raoulvdberge.refinedstorage.block.NetworkNodeBlock;
import com.raoulvdberge.refinedstorage.capability.NetworkNodeProxyCapability;
import com.raoulvdberge.refinedstorage.tile.CableTile;
import com.raoulvdberge.refinedstorage.util.BlockUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CableBlock
extends NetworkNodeBlock {
    private static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    protected static final VoxelShape HOLDER_NORTH = CableBlock.func_208617_a((double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)6.0);
    protected static final VoxelShape HOLDER_EAST = CableBlock.func_208617_a((double)10.0, (double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_SOUTH = CableBlock.func_208617_a((double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0, (double)14.0);
    protected static final VoxelShape HOLDER_WEST = CableBlock.func_208617_a((double)2.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_UP = CableBlock.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape HOLDER_DOWN = CableBlock.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final VoxelShape SHAPE_CORE = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SHAPE_EAST = CableBlock.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = CableBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = CableBlock.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_DOWN = CableBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public CableBlock(Block.Properties props) {
        super(props);
    }

    public CableBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.setRegistryName("refinedstorage", "cable");
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        return shape;
    }

    @Override
    protected void onDirectionChanged(World world, BlockPos pos, Direction newDirection) {
        world.func_175656_a(pos, this.getState(world.func_180495_p(pos), (IWorld)world, pos));
        super.onDirectionChanged(world, pos, newDirection);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getState(this.func_176223_P(), (IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    private boolean hasNode(IWorld world, BlockPos pos, BlockState state, Direction direction) {
        if (this.getDirection() != BlockDirection.NONE && ((Direction)state.func_177229_b((IProperty)this.getDirection().getProperty())).func_176734_d() == direction) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        return tile.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY, direction).isPresent();
    }

    private BlockState getState(BlockState currentState, IWorld world, BlockPos pos) {
        boolean north = this.hasNode(world, pos.func_177972_a(Direction.NORTH), currentState, Direction.SOUTH);
        boolean east = this.hasNode(world, pos.func_177972_a(Direction.EAST), currentState, Direction.WEST);
        boolean south = this.hasNode(world, pos.func_177972_a(Direction.SOUTH), currentState, Direction.NORTH);
        boolean west = this.hasNode(world, pos.func_177972_a(Direction.WEST), currentState, Direction.EAST);
        boolean up = this.hasNode(world, pos.func_177972_a(Direction.UP), currentState, Direction.DOWN);
        boolean down = this.hasNode(world, pos.func_177972_a(Direction.DOWN), currentState, Direction.UP);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(up))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CableTile();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

