/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.CrafterNetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockDirection;
import com.raoulvdberge.refinedstorage.block.NetworkNodeBlock;
import com.raoulvdberge.refinedstorage.container.CrafterContainer;
import com.raoulvdberge.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.raoulvdberge.refinedstorage.tile.CrafterTile;
import com.raoulvdberge.refinedstorage.util.BlockUtils;
import com.raoulvdberge.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrafterBlock
extends NetworkNodeBlock {
    public CrafterBlock() {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.setRegistryName("refinedstorage", "crafter");
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY_FACE_PLAYER;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrafterTile();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof CrafterTile && stack.func_82837_s()) {
            ((CrafterNetworkNode)((CrafterTile)tile).getNode()).setDisplayName(stack.func_200301_q());
            ((CrafterNetworkNode)((CrafterTile)tile).getNode()).markDirty();
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            return NetworkUtils.attempt(world, pos, hit.func_216354_b(), player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<CrafterTile>(((CrafterNetworkNode)((CrafterTile)world.func_175625_s(pos)).getNode()).getName(), (tile, windowId, inventory, p) -> new CrafterContainer((CrafterTile)tile, player, windowId), pos), (BlockPos)pos), Permission.MODIFY, Permission.AUTOCRAFTING);
        }
        return true;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

