/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.factory.PortableGridBlockGridFactory;
import com.raoulvdberge.refinedstorage.block.BaseBlock;
import com.raoulvdberge.refinedstorage.block.BlockDirection;
import com.raoulvdberge.refinedstorage.item.blockitem.PortableGridBlockItem;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGridDiskState;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGridTile;
import com.raoulvdberge.refinedstorage.util.BlockUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PortableGridBlock
extends BaseBlock {
    public static final EnumProperty<PortableGridDiskState> DISK_STATE = EnumProperty.func_177709_a((String)"disk_state", PortableGridDiskState.class);
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    private static final VoxelShape SHAPE = PortableGridBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.2, (double)16.0);
    private final PortableGridBlockItem.Type type;

    public PortableGridBlock(PortableGridBlockItem.Type type) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.type = type;
        this.setRegistryName("refinedstorage", (type == PortableGridBlockItem.Type.CREATIVE ? "creative_" : "") + "portable_grid");
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(DISK_STATE, (Comparable)((Object)PortableGridDiskState.NONE))).func_206870_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{DISK_STATE});
        builder.func_206894_a(new IProperty[]{ACTIVE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.HORIZONTAL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortableGridTile(this.type);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            API.instance().getGridManager().openGrid(PortableGridBlockGridFactory.ID, (ServerPlayerEntity)player, pos);
            ((PortableGridTile)world.func_175625_s(pos)).onOpened();
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            ((PortableGridTile)world.func_175625_s(pos)).applyDataFromItemToTile(stack);
            ((PortableGridTile)world.func_175625_s(pos)).updateState();
        }
    }
}

