/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.item;

import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.validator.UpgradeItemValidator;
import com.raoulvdberge.refinedstorage.item.UpgradeItem;
import net.minecraft.item.ItemStack;

public class UpgradeItemHandler
extends BaseItemHandler {
    public UpgradeItemHandler(int size, UpgradeItem.Type ... supportedUpgrades) {
        super(size);
        for (int i = 0; i < supportedUpgrades.length; ++i) {
            this.addValidator(new UpgradeItemValidator(supportedUpgrades[i]));
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.func_77973_b() instanceof UpgradeItem) || ((UpgradeItem)slot.func_77973_b()).getType() != UpgradeItem.Type.SPEED) continue;
            speed -= speedIncrease;
        }
        return speed;
    }

    public boolean hasUpgrade(UpgradeItem.Type type) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.func_77973_b() instanceof UpgradeItem) || ((UpgradeItem)slot.func_77973_b()).getType() != type) continue;
            return true;
        }
        return false;
    }

    public int getUpgradeCount(UpgradeItem.Type type) {
        int upgrades = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.func_77973_b() instanceof UpgradeItem) || ((UpgradeItem)slot.func_77973_b()).getType() != type) continue;
            ++upgrades;
        }
        return upgrades;
    }

    public int getEnergyUsage() {
        int usage = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.func_77973_b() instanceof UpgradeItem)) continue;
            usage += ((UpgradeItem)slot.func_77973_b()).getType().getEnergyUsage();
        }
        return usage;
    }

    public int getFortuneLevel() {
        int maxFortune = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            int fortune;
            ItemStack slot = this.getStackInSlot(i);
            if (!(slot.func_77973_b() instanceof UpgradeItem) || (fortune = ((UpgradeItem)slot.func_77973_b()).getType().getFortuneLevel()) <= maxFortune) continue;
            maxFortune = fortune;
        }
        return maxFortune;
    }

    public int getStackInteractCount() {
        return this.hasUpgrade(UpgradeItem.Type.STACK) ? 64 : 1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

