/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeItem
extends Item {
    private final Type type;

    public UpgradeItem(Type type) {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP));
        this.type = type;
        this.setRegistryName("refinedstorage", type == Type.NORMAL ? "upgrade" : type.getName() + "_upgrade");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.type.getFortuneLevel() > 0) {
            tooltip.add(new TranslationTextComponent("enchantment.minecraft.fortune", new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("enchantment.level." + this.type.getFortuneLevel(), new Object[0])).func_150255_a(Styles.GRAY));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.type == Type.SILK_TOUCH || this.type == Type.FORTUNE_1 || this.type == Type.FORTUNE_2 || this.type == Type.FORTUNE_3;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        NORMAL("normal"),
        SPEED("speed"),
        RANGE("range"),
        CRAFTING("crafting"),
        STACK("stack"),
        SILK_TOUCH("silk_touch"),
        FORTUNE_1("fortune_1"),
        FORTUNE_2("fortune_2"),
        FORTUNE_3("fortune_3");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getEnergyUsage() {
            switch (this) {
                case NORMAL: {
                    return 0;
                }
                case RANGE: {
                    return RS.SERVER_CONFIG.getUpgrades().getRangeUpgradeUsage();
                }
                case SPEED: {
                    return RS.SERVER_CONFIG.getUpgrades().getSpeedUpgradeUsage();
                }
                case CRAFTING: {
                    return RS.SERVER_CONFIG.getUpgrades().getCraftingUpgradeUsage();
                }
                case STACK: {
                    return RS.SERVER_CONFIG.getUpgrades().getStackUpgradeUsage();
                }
                case SILK_TOUCH: {
                    return RS.SERVER_CONFIG.getUpgrades().getSilkTouchUpgradeUsage();
                }
                case FORTUNE_1: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune1UpgradeUsage();
                }
                case FORTUNE_2: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune2UpgradeUsage();
                }
                case FORTUNE_3: {
                    return RS.SERVER_CONFIG.getUpgrades().getFortune3UpgradeUsage();
                }
            }
            throw new IllegalStateException("What even am I?");
        }

        public int getFortuneLevel() {
            switch (this) {
                case FORTUNE_1: {
                    return 1;
                }
                case FORTUNE_2: {
                    return 2;
                }
                case FORTUNE_3: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

