/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.DiskState;
import com.raoulvdberge.refinedstorage.render.model.DelegateBakedModel;
import com.raoulvdberge.refinedstorage.render.model.TRSRBakedModel;
import com.raoulvdberge.refinedstorage.tile.DiskDriveTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.TRSRTransformation;

public class DiskDriveBakedModel
extends DelegateBakedModel {
    private Map<Direction, IBakedModel> baseByFacing = new HashMap<Direction, IBakedModel>();
    private Map<Direction, Map<DiskState, List<IBakedModel>>> disksByFacing = new HashMap<Direction, Map<DiskState, List<IBakedModel>>>();
    private LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            Direction facing = (Direction)key.state.func_177229_b((IProperty)RSBlocks.DISK_DRIVE.getDirection().getProperty());
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((IBakedModel)DiskDriveBakedModel.this.baseByFacing.get(facing)).func_200117_a(key.state, key.side, key.random));
            for (int i = 0; i < 8; ++i) {
                if (key.diskState[i] == DiskState.NONE) continue;
                quads.addAll(((IBakedModel)((List)((Map)DiskDriveBakedModel.this.disksByFacing.get(facing)).get((Object)key.diskState[i])).get(i)).func_200117_a(key.state, key.side, key.random));
            }
            return quads;
        }
    });

    public DiskDriveBakedModel(IBakedModel base, IBakedModel disk, IBakedModel diskNearCapacity, IBakedModel diskFull, IBakedModel diskDisconnected) {
        super(base);
        for (Direction facing : Direction.values()) {
            if (facing.func_176736_b() == -1) continue;
            this.baseByFacing.put(facing, new TRSRBakedModel(base, facing));
            this.disksByFacing.put(facing, new HashMap());
            this.addDiskModels(disk, DiskState.NORMAL, facing);
            this.addDiskModels(diskNearCapacity, DiskState.NEAR_CAPACITY, facing);
            this.addDiskModels(diskFull, DiskState.FULL, facing);
            this.addDiskModels(diskDisconnected, DiskState.DISCONNECTED, facing);
        }
    }

    private void addDiskModels(IBakedModel disk, DiskState type, Direction facing) {
        this.disksByFacing.get(facing).put(type, new ArrayList());
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                TRSRBakedModel model = new TRSRBakedModel(disk, facing);
                Vector3f trans = model.transformation.getTranslation();
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    trans.x = trans.x + (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.NORTH ? -1 : 1);
                } else if (facing == Direction.EAST || facing == Direction.WEST) {
                    trans.z = trans.z + (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.EAST ? -1 : 1);
                }
                trans.y -= 0.125f + (float)y * 3.0f / 16.0f;
                model.transformation = new TRSRTransformation(trans, model.transformation.getLeftRot(), model.transformation.getScale(), model.transformation.getRightRot());
                this.disksByFacing.get(facing).get((Object)type).add(model);
            }
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        DiskState[] diskState = (DiskState[])data.getData(DiskDriveTile.DISK_STATE_PROPERTY);
        if (diskState == null) {
            return this.base.getQuads(state, side, rand, data);
        }
        CacheKey key = new CacheKey(state, side, diskState, rand);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private class CacheKey {
        private BlockState state;
        private Direction side;
        private DiskState[] diskState;
        private Random random;

        CacheKey(@Nullable BlockState state, Direction side, DiskState[] diskState, Random random) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals((Object)cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

