/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.render.model.DelegateBakedModel;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class FullbrightBakedModel
extends DelegateBakedModel {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            return FullbrightBakedModel.transformQuads(key.base.getQuads(key.state, key.side, key.random, (IModelData)EmptyModelData.INSTANCE), key.textures);
        }
    });
    private Set<ResourceLocation> textures;
    private boolean cacheDisabled = false;

    public FullbrightBakedModel(IBakedModel base, ResourceLocation ... textures) {
        super(base);
        this.textures = new HashSet<ResourceLocation>(Arrays.asList(textures));
    }

    public FullbrightBakedModel disableCache() {
        this.cacheDisabled = true;
        return this;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        if (state == null) {
            return this.base.getQuads(state, side, rand, data);
        }
        if (this.cacheDisabled) {
            return FullbrightBakedModel.transformQuads(this.base.getQuads(state, side, rand, data), this.textures);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.base, this.textures, rand, state, side));
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, Set<ResourceLocation> textures) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!textures.contains(quad.func_187508_a().func_195668_m())) continue;
            quads.set(i, FullbrightBakedModel.transformQuad(quad, 0.007f));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad, final float light) {
        if (RenderUtils.isLightMapDisabled()) {
            return quad;
        }
        VertexFormat newFormat = RenderUtils.getFormatWithLightMap(quad.getFormat());
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

            protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                lightmap[0] = light;
                lightmap[1] = light;
            }

            public void setQuadTint(int tint) {
            }
        };
        trans.setParent((IVertexConsumer)builder);
        quad.pipe((IVertexConsumer)trans);
        builder.setQuadTint(quad.func_178211_c());
        builder.setQuadOrientation(quad.func_178210_d());
        builder.setTexture(quad.func_187508_a());
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }

    private class CacheKey {
        private IBakedModel base;
        private Set<ResourceLocation> textures;
        private Random random;
        private BlockState state;
        private Direction side;

        public CacheKey(IBakedModel base, Set<ResourceLocation> textures, Random random, BlockState state, Direction side) {
            this.base = base;
            this.textures = textures;
            this.random = random;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (cacheKey.side != this.side) {
                return false;
            }
            return this.state.equals((Object)cacheKey.state);
        }

        public int hashCode() {
            return this.state.hashCode() + 31 * (this.side != null ? this.side.hashCode() : 0);
        }
    }
}

