/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.block.PortableGridBlock;
import com.raoulvdberge.refinedstorage.render.model.DelegateBakedModel;
import com.raoulvdberge.refinedstorage.render.model.PortableGridItemBakedModel;
import com.raoulvdberge.refinedstorage.render.model.TRSRBakedModel;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGridDiskState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.world.World;

public class PortableGridBakedModel
extends DelegateBakedModel {
    private final IBakedModel baseConnected;
    private final IBakedModel baseDisconnected;
    private final IBakedModel disk;
    private final IBakedModel diskNearCapacity;
    private final IBakedModel diskFull;
    private final IBakedModel diskDisconnected;
    private final CustomItemOverrideList itemOverrideList = new CustomItemOverrideList();
    private LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (key.active) {
                quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.baseConnected, key.direction).func_200117_a(key.state, key.side, key.random));
            } else {
                quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.baseDisconnected, key.direction).func_200117_a(key.state, key.side, key.random));
            }
            switch (key.diskState) {
                case NORMAL: {
                    quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.disk, key.direction).func_200117_a(key.state, key.side, key.random));
                    break;
                }
                case NEAR_CAPACITY: {
                    quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.diskNearCapacity, key.direction).func_200117_a(key.state, key.side, key.random));
                    break;
                }
                case FULL: {
                    quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.diskFull, key.direction).func_200117_a(key.state, key.side, key.random));
                    break;
                }
                case DISCONNECTED: {
                    quads.addAll(new TRSRBakedModel(PortableGridBakedModel.this.diskDisconnected, key.direction).func_200117_a(key.state, key.side, key.random));
                    break;
                }
            }
            return quads;
        }
    });

    public PortableGridBakedModel(IBakedModel baseConnected, IBakedModel baseDisconnected, IBakedModel disk, IBakedModel diskNearCapacity, IBakedModel diskFull, IBakedModel diskDisconnected) {
        super(baseConnected);
        this.baseConnected = baseConnected;
        this.baseDisconnected = baseDisconnected;
        this.disk = disk;
        this.diskNearCapacity = diskNearCapacity;
        this.diskFull = diskFull;
        this.diskDisconnected = diskDisconnected;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state != null) {
            Direction direction = (Direction)state.func_177229_b((IProperty)RSBlocks.PORTABLE_GRID.getDirection().getProperty());
            boolean active = (Boolean)state.func_177229_b((IProperty)PortableGridBlock.ACTIVE);
            PortableGridDiskState diskState = (PortableGridDiskState)((Object)state.func_177229_b(PortableGridBlock.DISK_STATE));
            return (List)this.cache.getUnchecked((Object)new CacheKey(direction, diskState, active, rand, state, side));
        }
        return super.func_200117_a(state, side, rand);
    }

    private class CacheKey {
        private final Direction direction;
        private final PortableGridDiskState diskState;
        private final boolean active;
        private final Random random;
        private final BlockState state;
        private final Direction side;

        public CacheKey(Direction direction, PortableGridDiskState diskState, boolean active, Random random, BlockState state, Direction side) {
            this.direction = direction;
            this.diskState = diskState;
            this.active = active;
            this.random = random;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.active == cacheKey.active && this.direction == cacheKey.direction && this.diskState == cacheKey.diskState;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.direction, this.diskState, this.active});
        }
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
        }

        @Nullable
        public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            PortableGrid portableGrid = new PortableGrid(null, stack, -1);
            IBakedModel myDisk = null;
            switch (portableGrid.getDiskState()) {
                case NORMAL: {
                    myDisk = PortableGridBakedModel.this.disk;
                    break;
                }
                case NEAR_CAPACITY: {
                    myDisk = PortableGridBakedModel.this.diskNearCapacity;
                    break;
                }
                case FULL: {
                    myDisk = PortableGridBakedModel.this.diskFull;
                    break;
                }
                case DISCONNECTED: {
                    myDisk = PortableGridBakedModel.this.diskDisconnected;
                    break;
                }
            }
            if (portableGrid.isGridActive()) {
                return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseConnected, myDisk);
            }
            return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseDisconnected, myDisk);
        }
    }
}

