/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;

public class TRSRBakedModel
implements IBakedModel {
    protected final IBakedModel original;
    protected TRSRTransformation transformation;
    private final int faceOffset;

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new TRSRTransformation(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TRSRTransformation.quatFromXYZ((float)rotX, (float)rotY, (float)rotZ)));
    }

    public TRSRBakedModel(IBakedModel original, TRSRTransformation transform) {
        this.original = original;
        this.transformation = TRSRTransformation.blockCenterToCorner((TRSRTransformation)transform);
        this.faceOffset = 0;
    }

    public TRSRBakedModel(IBakedModel original, Direction facing) {
        this.original = original;
        this.faceOffset = 4 + Direction.NORTH.func_176736_b() - facing.func_176736_b();
        double r = Math.PI * (double)(360 - facing.func_176734_d().func_176736_b() * 90) / 180.0;
        TRSRTransformation t = new TRSRTransformation(null, null, null, TRSRTransformation.quatFromXYZ((float)0.0f, (float)((float)r), (float)0.0f));
        this.transformation = TRSRTransformation.blockCenterToCorner((TRSRTransformation)t);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!this.original.func_188618_c()) {
            try {
                if (side != null && side.func_176736_b() > -1) {
                    side = Direction.func_176731_b((int)((side.func_176736_b() + this.faceOffset) % 4));
                }
                for (BakedQuad quad : this.original.func_200117_a(state, side, rand)) {
                    Transformer transformer = new Transformer(this.transformation, quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }

    private static class Transformer
    extends VertexTransformer {
        protected Matrix4f transformation;
        protected Matrix3f normalTransformation;

        public Transformer(TRSRTransformation transformation, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.transformation = transformation.getMatrixVec();
            this.normalTransformation = new Matrix3f();
            this.transformation.getRotationScale(this.normalTransformation);
            this.normalTransformation.invert();
            this.normalTransformation.transpose();
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.Usage.POSITION && data.length >= 3) {
                Vector4f vec = new Vector4f(data[0], data[1], data[2], 1.0f);
                this.transformation.transform((Tuple4f)vec);
                data = new float[4];
                vec.get(data);
            } else if (usage == VertexFormatElement.Usage.NORMAL && data.length >= 3) {
                Vector3f vec = new Vector3f(data);
                this.normalTransformation.transform((Tuple3f)vec);
                vec.normalize();
                data = new float[4];
                vec.get(data);
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

