/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.FilterContainer;
import com.raoulvdberge.refinedstorage.item.FilterItem;
import com.raoulvdberge.refinedstorage.network.FilterUpdateMessage;
import com.raoulvdberge.refinedstorage.render.RenderSettings;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.FilterTypeSideButton;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class FilterScreen
extends BaseScreen<FilterContainer> {
    private ItemStack stack;
    private int compare;
    private int mode;
    private boolean modFilter;
    private String name;
    private int type;
    private GuiCheckBox modFilterCheckBox;
    private Button modeButton;
    private TextFieldWidget nameField;

    public FilterScreen(FilterContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 176, 231, inventory, title);
        this.stack = container.getStack();
        this.compare = FilterItem.getCompare(container.getStack());
        this.mode = FilterItem.getMode(container.getStack());
        this.modFilter = FilterItem.isModFilter(container.getStack());
        this.name = FilterItem.getName(container.getStack());
        this.type = FilterItem.getType(container.getStack());
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addCheckBox(x + 7, y + 77, I18n.func_135052_a((String)"gui.refinedstorage.filter.compare_nbt", (Object[])new Object[0]), (this.compare & 1) == 1, btn -> {
            this.compare ^= 1;
            this.sendUpdate();
        });
        this.modFilterCheckBox = this.addCheckBox(0, y + 71 + 25, I18n.func_135052_a((String)"gui.refinedstorage.filter.mod_filter", (Object[])new Object[0]), this.modFilter, btn -> {
            this.modFilter = !this.modFilter;
            this.sendUpdate();
        });
        this.modeButton = this.addButton(x + 7, y + 71 + 21, 0, 20, "", true, true, btn -> {
            this.mode = this.mode == 0 ? 1 : 0;
            this.updateModeButton(this.mode);
            this.sendUpdate();
        });
        this.updateModeButton(this.mode);
        this.font.getClass();
        this.nameField = new TextFieldWidget(this.font, x + 34, y + 121, 131, 9, "");
        this.nameField.func_146180_a(this.name);
        this.nameField.func_146185_a(false);
        this.nameField.func_146189_e(true);
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146193_g(RenderSettings.INSTANCE.getSecondaryColor());
        this.nameField.func_212954_a(name -> this.sendUpdate());
        this.addButton((Widget)this.nameField);
        this.addSideButton(new FilterTypeSideButton(this));
    }

    private void updateModeButton(int mode) {
        String text = mode == 0 ? I18n.func_135052_a((String)"sidebutton.refinedstorage.mode.whitelist", (Object[])new Object[0]) : I18n.func_135052_a((String)"sidebutton.refinedstorage.mode.blacklist", (Object[])new Object[0]);
        this.modeButton.setWidth(this.font.func_78256_a(text) + 12);
        this.modeButton.setMessage(text);
        this.modFilterCheckBox.x = this.modeButton.x + this.modeButton.getWidth() + 4;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        if (this.nameField.keyPressed(key, scanCode, modifiers) || this.nameField.func_212955_f()) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/filter.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        this.renderString(7, 137, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        FilterItem.setType(this.stack, type);
    }

    public void sendUpdate() {
        RS.NETWORK_HANDLER.sendToServer(new FilterUpdateMessage(this.compare, this.mode, this.modFilter, this.nameField.func_146179_b(), this.type));
    }
}

