/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SecurityManagerNetworkNode;
import com.raoulvdberge.refinedstorage.container.SecurityManagerContainer;
import com.raoulvdberge.refinedstorage.item.SecurityCardItem;
import com.raoulvdberge.refinedstorage.network.SecurityManagerUpdateMessage;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.raoulvdberge.refinedstorage.tile.SecurityManagerTile;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class SecurityManagerScreen
extends BaseScreen<SecurityManagerContainer> {
    private final SecurityManagerTile securityManager;
    private GuiCheckBox[] permissions = new GuiCheckBox[Permission.values().length];

    public SecurityManagerScreen(SecurityManagerContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 176, 234, inventory, title);
        this.securityManager = (SecurityManagerTile)container.getTile();
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, SecurityManagerTile.REDSTONE_MODE));
        int padding = 15;
        this.permissions[0] = this.addCheckBox(x + 7, y + 93, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.0", (Object[])new Object[0]), false, btn -> this.handle(0));
        this.permissions[1] = this.addCheckBox(this.permissions[0].x, this.permissions[0].y + padding, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.1", (Object[])new Object[0]), false, btn -> this.handle(1));
        this.permissions[2] = this.addCheckBox(this.permissions[1].x, this.permissions[1].y + padding, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.2", (Object[])new Object[0]), false, btn -> this.handle(2));
        this.permissions[3] = this.addCheckBox(this.permissions[0].x + 90, this.permissions[0].y, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.3", (Object[])new Object[0]), false, btn -> this.handle(3));
        this.permissions[4] = this.addCheckBox(this.permissions[3].x, this.permissions[3].y + padding, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.4", (Object[])new Object[0]), false, btn -> this.handle(4));
        this.permissions[5] = this.addCheckBox(this.permissions[4].x, this.permissions[4].y + padding, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.permission.5", (Object[])new Object[0]), false, btn -> this.handle(5));
    }

    private void handle(int i) {
        RS.NETWORK_HANDLER.sendToServer(new SecurityManagerUpdateMessage(this.securityManager.func_174877_v(), Permission.values()[i], this.permissions[i].isChecked()));
    }

    @Override
    public void tick(int x, int y) {
        ItemStack card = ((SecurityManagerNetworkNode)this.securityManager.getNode()).getEditCard().getStackInSlot(0);
        for (Permission permission : Permission.values()) {
            this.permissions[permission.getId()].setIsChecked(!card.func_190926_b() && SecurityCardItem.hasPermission(card, permission));
        }
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/security_manager.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        this.renderString(7, 59, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.configure", (Object[])new Object[0]));
        this.renderString(7, 140, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        for (int i = 0; i < this.permissions.length; ++i) {
            GuiCheckBox permission = this.permissions[i];
            if (!RenderUtils.inBounds(permission.x - this.field_147003_i, permission.y - this.field_147009_r, permission.getWidth(), permission.getHeight(), mouseX, mouseY)) continue;
            this.renderTooltip(mouseX, mouseY, I18n.func_135052_a((String)("gui.refinedstorage.security_manager.permission." + i + ".tooltip"), (Object[])new Object[0]));
        }
    }
}

