/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid;

import com.raoulvdberge.refinedstorage.container.AlternativesContainer;
import com.raoulvdberge.refinedstorage.render.FluidRenderer;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.widget.CheckBoxWidget;
import com.raoulvdberge.refinedstorage.screen.widget.ScrollbarWidget;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.GridTile;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class AlternativesScreen
extends BaseScreen {
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final List<Line> lines = new ArrayList<Line>();
    private int type;
    private int slot;
    private ItemStack item;
    private FluidStack fluid;

    private AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title) {
        super(new AlternativesContainer(player), 175, 143, null, title);
        this.parent = parent;
        this.scrollbar = new ScrollbarWidget(this, 155, 20, 12, 89);
    }

    public AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title, ItemStack item, int slot) {
        this(parent, player, title);
        this.type = 0;
        this.slot = slot;
        this.item = item;
        this.fluid = null;
    }

    public AlternativesScreen(Screen parent, PlayerEntity player, ITextComponent title, FluidStack fluid, int slot) {
        this(parent, player, title);
        this.type = 1;
        this.slot = slot;
        this.item = null;
        this.fluid = fluid;
    }

    @Override
    public void onPostInit(int x, int y) {
        Line line;
        this.lines.clear();
        if (this.item != null) {
            this.lines.add(new ItemLine(this.item));
            for (ResourceLocation owningTag : ItemTags.func_199903_a().func_199913_a((Object)this.item.func_77973_b())) {
                this.lines.add(new TagLine(owningTag, GridTile.ALLOWED_ITEM_TAGS.getValue().get(this.slot).contains(owningTag)));
                int itemCount = 0;
                line = new ItemListLine();
                for (Item item : ItemTags.func_199903_a().func_199910_a(owningTag).func_199885_a()) {
                    if (itemCount > 0 && itemCount % 8 == 0) {
                        this.lines.add(line);
                        line = new ItemListLine();
                    }
                    ++itemCount;
                    ((ItemListLine)line).addItem(new ItemStack((IItemProvider)item));
                }
                this.lines.add(line);
            }
        } else if (this.fluid != null) {
            this.lines.add(new FluidLine(this.fluid));
            for (ResourceLocation owningTag : FluidTags.getCollection().func_199913_a((Object)this.fluid.getFluid())) {
                this.lines.add(new TagLine(owningTag, GridTile.ALLOWED_FLUID_TAGS.getValue().get(this.slot).contains(owningTag)));
                int fluidCount = 0;
                line = new FluidListLine();
                for (Fluid fluid : FluidTags.getCollection().func_199910_a(owningTag).func_199885_a()) {
                    if (fluidCount > 0 && fluidCount % 8 == 0) {
                        this.lines.add(line);
                        line = new FluidListLine();
                    }
                    ++fluidCount;
                    ((FluidListLine)line).addFluid(new FluidStack(fluid, 1000));
                }
                this.lines.add(line);
            }
        }
        int xx = 8;
        int yy = 20;
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean visible;
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + this.getVisibleRows();
            if (!visible) continue;
            this.lines.get(i).layoutDependantControls(true, this.field_147003_i + xx + 3, this.field_147009_r + yy + 3);
            yy += 18;
        }
        Button apply = this.addButton(x + 7, y + 114, 50, 20, I18n.func_135052_a((String)"gui.refinedstorage.alternatives.apply", (Object[])new Object[0]), this.lines.size() > 1, true, btn -> this.apply());
        this.addButton(x + apply.getWidth() + 7 + 4, y + 114, 50, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), true, true, btn -> this.close());
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    private int getRows() {
        return this.lines.size();
    }

    private int getVisibleRows() {
        return 5;
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/alternatives.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.scrollbar.render();
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        boolean visible;
        int i;
        this.renderString(7, 7, this.title.func_150254_d());
        int x = 8;
        int y = 20;
        RenderHelper.func_74520_c();
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + this.getVisibleRows();
            if (visible) {
                this.lines.get(i).layoutDependantControls(true, this.field_147003_i + x + 3, this.field_147009_r + y + 3);
                this.lines.get(i).render(x, y);
                y += 18;
                continue;
            }
            this.lines.get(i).layoutDependantControls(false, -100, -100);
        }
        x = 8;
        y = 20;
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + this.getVisibleRows();
            if (!visible) continue;
            this.lines.get(i).renderTooltip(x, y, mouseX, mouseY);
            y += 18;
        }
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        return this.scrollbar.mouseClicked(mx, my, button) || super.mouseClicked(mx, my, button);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return this.scrollbar.mouseScrolled(x, y, delta) || super.mouseScrolled(x, y, delta);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private void close() {
        this.minecraft.func_147108_a(this.parent);
    }

    private void apply() {
        List<Set<ResourceLocation>> existing;
        HashSet<ResourceLocation> allowed = new HashSet<ResourceLocation>();
        for (Line line : this.lines) {
            TagLine tagLine;
            if (!(line instanceof TagLine) || !(tagLine = (TagLine)line).widget.isChecked()) continue;
            allowed.add(tagLine.tagName);
        }
        if (this.type == 0) {
            existing = GridTile.ALLOWED_ITEM_TAGS.getValue();
            existing.set(this.slot, allowed);
            TileDataManager.setParameter(GridTile.ALLOWED_ITEM_TAGS, existing);
        } else if (this.type == 1) {
            existing = GridTile.ALLOWED_FLUID_TAGS.getValue();
            existing.set(this.slot, allowed);
            TileDataManager.setParameter(GridTile.ALLOWED_FLUID_TAGS, existing);
        }
        this.close();
    }

    private class FluidListLine
    implements Line {
        private final List<FluidStack> fluids = new ArrayList<FluidStack>();

        private FluidListLine() {
        }

        public FluidListLine addFluid(FluidStack stack) {
            this.fluids.add(stack);
            return this;
        }

        @Override
        public void render(int x, int y) {
            for (FluidStack fluid : this.fluids) {
                FluidRenderer.INSTANCE.render(x + 3, y, fluid);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(int x, int y, int mx, int my) {
            for (FluidStack fluid : this.fluids) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(mx, my, fluid.getDisplayName().func_150254_d());
                }
                x += 17;
            }
        }
    }

    private class ItemListLine
    implements Line {
        private final List<ItemStack> items = new ArrayList<ItemStack>();

        private ItemListLine() {
        }

        public ItemListLine addItem(ItemStack stack) {
            this.items.add(stack);
            return this;
        }

        @Override
        public void render(int x, int y) {
            for (ItemStack item : this.items) {
                AlternativesScreen.this.renderItem(x + 3, y, item);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(int x, int y, int mx, int my) {
            for (ItemStack item : this.items) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(item, mx, my, RenderUtils.getTooltipFromItem(item));
                }
                x += 17;
            }
        }
    }

    private class TagLine
    implements Line {
        private final ResourceLocation tagName;
        private final CheckBoxWidget widget;

        public TagLine(ResourceLocation tagName, boolean checked) {
            this.tagName = tagName;
            this.widget = AlternativesScreen.this.addCheckBox(-100, -100, RenderUtils.shorten(tagName.toString(), 22), checked, btn -> {});
            this.widget.setFGColor(-13158601);
            this.widget.setShadow(false);
        }

        @Override
        public void layoutDependantControls(boolean visible, int x, int y) {
            this.widget.visible = visible;
            this.widget.x = x;
            this.widget.y = y;
        }
    }

    private class FluidLine
    implements Line {
        private final FluidStack fluid;

        public FluidLine(FluidStack item) {
            this.fluid = item;
        }

        @Override
        public void render(int x, int y) {
            FluidRenderer.INSTANCE.render(x + 3, y + 2, this.fluid);
            AlternativesScreen.this.renderString(x + 4 + 19, y + 7, this.fluid.getDisplayName().func_150254_d());
        }
    }

    private class ItemLine
    implements Line {
        private final ItemStack item;

        public ItemLine(ItemStack item) {
            this.item = item;
        }

        @Override
        public void render(int x, int y) {
            AlternativesScreen.this.renderItem(x + 3, y + 2, this.item);
            AlternativesScreen.this.renderString(x + 4 + 19, y + 7, this.item.func_200301_q().func_150254_d());
        }
    }

    private static interface Line {
        default public void render(int x, int y) {
        }

        default public void renderTooltip(int x, int y, int mx, int my) {
        }

        default public void layoutDependantControls(boolean visible, int x, int y) {
        }
    }
}

