/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid;

import com.mojang.blaze3d.platform.GlStateManager;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.render.CraftingPreviewElementDrawers;
import com.raoulvdberge.refinedstorage.item.PatternItem;
import com.raoulvdberge.refinedstorage.network.grid.GridCraftingStartRequestMessage;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.widget.ScrollbarWidget;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPreviewScreen
extends BaseScreen {
    private static final int VISIBLE_ROWS = 5;
    private final List<ICraftingPreviewElement> stacks;
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final UUID id;
    private final int quantity;
    private final boolean fluids;
    private ItemStack hoveringStack;
    private FluidStack hoveringFluid;
    private IElementDrawers drawers;

    public CraftingPreviewScreen(Screen parent, List<ICraftingPreviewElement> stacks, UUID id, int quantity, boolean fluids, ITextComponent title) {
        super(new Container(null, 0){

            public boolean func_75145_c(PlayerEntity player) {
                return false;
            }
        }, 254, 201, null, title);
        this.drawers = new CraftingPreviewElementDrawers(this, this.font);
        this.stacks = new ArrayList<ICraftingPreviewElement>(stacks);
        this.parent = parent;
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
        this.scrollbar = new ScrollbarWidget(this, 235, 20, 12, 149);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addButton(x + 55, y + 201 - 20 - 7, 50, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), true, true, btn -> this.close());
        Button startButton = this.addButton(x + 129, y + 201 - 20 - 7, 50, 20, I18n.func_135052_a((String)"misc.refinedstorage.start", (Object[])new Object[0]), true, true, btn -> this.startRequest());
        startButton.active = this.stacks.stream().noneMatch(ICraftingPreviewElement::hasMissing) && this.getErrorType() == null;
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
    }

    @Nullable
    private CraftingTaskErrorType getErrorType() {
        if (this.stacks.size() == 1 && this.stacks.get(0) instanceof ErrorCraftingPreviewElement) {
            return ((ErrorCraftingPreviewElement)this.stacks.get(0)).getType();
        }
        return null;
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/crafting_preview.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.getErrorType() != null) {
            CraftingPreviewScreen.fill((int)(x + 7), (int)(y + 20), (int)(x + 228), (int)(y + 169), (int)-2368549);
        }
        this.scrollbar.render();
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        block12: {
            int y;
            int x;
            block11: {
                float scale;
                this.renderString(7, 7, this.title.func_150254_d());
                x = 7;
                y = 15;
                float f = scale = Minecraft.func_71410_x().func_211821_e() ? 1.0f : 0.5f;
                if (this.getErrorType() == null) break block11;
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
                this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 11, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error", (Object[])new Object[0]));
                switch (this.getErrorType()) {
                    case RECURSIVE: {
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.0", (Object[])new Object[0]));
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.1", (Object[])new Object[0]));
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 41, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.2", (Object[])new Object[0]));
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 51, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.3", (Object[])new Object[0]));
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 61, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.4", (Object[])new Object[0]));
                        GlStateManager.popMatrix();
                        CraftingPattern pattern = PatternItem.fromCache((World)this.parent.getMinecraft().field_71441_e, (ItemStack)this.stacks.get(0).getElement());
                        int yy = 83;
                        for (ItemStack output : pattern.getOutputs()) {
                            if (output == null) continue;
                            GlStateManager.pushMatrix();
                            GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
                            this.renderString(RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy + 6, scale), output.func_200301_q().func_150254_d());
                            GlStateManager.popMatrix();
                            RenderHelper.func_74520_c();
                            GlStateManager.enableDepthTest();
                            this.renderItem(x + 5, yy, output);
                            RenderHelper.func_74518_a();
                            yy += 17;
                        }
                        break block12;
                    }
                    case TOO_COMPLEX: {
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.too_complex.0", (Object[])new Object[0]));
                        this.renderString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.too_complex.1", (Object[])new Object[0]));
                        GlStateManager.popMatrix();
                    }
                }
                break block12;
            }
            int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
            RenderHelper.func_74520_c();
            GlStateManager.enableDepthTest();
            this.hoveringStack = null;
            this.hoveringFluid = null;
            for (int i = 0; i < 15; ++i) {
                if (slot < this.stacks.size()) {
                    ICraftingPreviewElement stack = this.stacks.get(slot);
                    stack.draw(x, y + 5, this.drawers);
                    if (RenderUtils.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
                        ItemStack itemStack = this.hoveringStack = stack.getId().equals((Object)ItemCraftingPreviewElement.ID) ? (ItemStack)stack.getElement() : null;
                        if (this.hoveringStack == null) {
                            FluidStack fluidStack = this.hoveringFluid = stack.getId().equals((Object)FluidCraftingPreviewElement.ID) ? (FluidStack)stack.getElement() : null;
                        }
                    }
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
                ++slot;
            }
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.hoveringStack != null) {
            this.renderTooltip(this.hoveringStack, mouseX, mouseY, this.hoveringStack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()));
        } else if (this.hoveringFluid != null) {
            this.renderTooltip(mouseX, mouseY, this.hoveringFluid.getDisplayName().func_150254_d());
        }
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        return this.scrollbar.mouseClicked(mx, my, button) || super.mouseClicked(mx, my, button);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return this.scrollbar.mouseScrolled(x, y, delta) || super.mouseScrolled(x, y, delta);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 257 || key == 335) {
            this.startRequest();
            return true;
        }
        if (key == 256) {
            this.close();
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private void startRequest() {
        RS.NETWORK_HANDLER.sendToServer(new GridCraftingStartRequestMessage(this.id, this.quantity, this.fluids));
        this.close();
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.stacks.size() / 3.0f));
    }

    private void close() {
        this.minecraft.func_147108_a(this.parent);
    }
}

