/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.render.ElementDrawers;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import com.raoulvdberge.refinedstorage.network.grid.GridClearMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridFluidInsertHeldMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridFluidPullMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridItemInsertHeldMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridItemPullMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridPatternCreateMessage;
import com.raoulvdberge.refinedstorage.screen.BaseScreen;
import com.raoulvdberge.refinedstorage.screen.IScreenInfoProvider;
import com.raoulvdberge.refinedstorage.screen.grid.CraftingSettingsScreen;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.IdGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.InventoryTweaksGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.LastModifiedGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.NameGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.QuantityGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.ItemGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.view.FluidGridView;
import com.raoulvdberge.refinedstorage.screen.grid.view.IGridView;
import com.raoulvdberge.refinedstorage.screen.grid.view.ItemGridView;
import com.raoulvdberge.refinedstorage.screen.widget.ScrollbarWidget;
import com.raoulvdberge.refinedstorage.screen.widget.SearchWidget;
import com.raoulvdberge.refinedstorage.screen.widget.TabListWidget;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.GridSearchBoxModeSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.GridSizeSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.GridSortingDirectionSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.GridSortingTypeSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.GridViewTypeSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.raoulvdberge.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.GridTile;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.PortableGridTile;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.TimeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class GridScreen
extends BaseScreen<GridContainer>
implements IScreenInfoProvider {
    private IGridView view;
    private SearchWidget searchField;
    private GuiCheckBox exactPattern;
    private GuiCheckBox processingPattern;
    private ScrollbarWidget scrollbar;
    private IGrid grid;
    private TabListWidget tabs;
    private boolean wasConnected;
    private boolean doSort;
    private int slotNumber;

    public GridScreen(GridContainer container, final IGrid grid, PlayerInventory inventory, ITextComponent title) {
        super(container, 227, 0, inventory, title);
        this.grid = grid;
        this.view = grid.getGridType() == GridType.FLUID ? new FluidGridView(this, GridScreen.getDefaultSorter(), GridScreen.getSorters()) : new ItemGridView(this, GridScreen.getDefaultSorter(), GridScreen.getSorters());
        this.wasConnected = this.grid.isGridActive();
        this.tabs = new TabListWidget(this, new ElementDrawers(this, this.font), grid::getTabs, grid::getTotalTabPages, grid::getTabPage, grid::getTabSelected, 5);
        this.tabs.addListener(new TabListWidget.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                grid.onTabSelectionChanged(tab);
            }

            @Override
            public void onPageChanged(int page) {
                grid.onTabPageChanged(page);
            }
        });
    }

    @Override
    protected void onPreInit() {
        super.onPreInit();
        this.doSort = true;
        this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void onPostInit(int x, int y) {
        ((GridContainer)this.field_147002_h).initSlots();
        this.tabs.init(this.field_146999_f - 32);
        this.scrollbar = new ScrollbarWidget(this, 174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof GridNetworkNode || this.grid instanceof PortableGridTile) {
            this.addSideButton(new RedstoneModeSideButton(this, this.grid instanceof GridNetworkNode ? GridTile.REDSTONE_MODE : PortableGridTile.REDSTONE_MODE));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new SearchWidget(this.font, sx, sy, 82);
            this.searchField.func_212954_a(value -> {
                this.searchField.updateJei();
                this.getView().sort();
            });
            this.searchField.setMode(this.grid.getSearchBoxMode());
        } else {
            this.searchField.x = sx;
            this.searchField.y = sy;
        }
        this.addButton((Widget)this.searchField);
        if (this.grid.getViewType() != -1) {
            this.addSideButton(new GridViewTypeSideButton(this, this.grid));
        }
        this.addSideButton(new GridSortingDirectionSideButton(this, this.grid));
        this.addSideButton(new GridSortingTypeSideButton(this, this.grid));
        this.addSideButton(new GridSearchBoxModeSideButton(this));
        this.addSideButton(new GridSizeSideButton(this, () -> this.grid.getSize(), size -> this.grid.onSizeChanged((int)size)));
        if (this.grid.getGridType() == GridType.PATTERN) {
            this.processingPattern = this.addCheckBox(x + 7, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, I18n.func_135052_a((String)"misc.refinedstorage.processing", (Object[])new Object[0]), GridTile.PROCESSING_PATTERN.getValue(), btn -> {
                GridTile.PROCESSING_PATTERN.setValue(false, this.processingPattern.isChecked());
                ((GridNetworkNode)this.grid).clearMatrix();
                ((GridContainer)this.field_147002_h).initSlots();
                TileDataManager.setParameter(GridTile.PROCESSING_PATTERN, this.processingPattern.isChecked());
            });
            if (!this.processingPattern.isChecked()) {
                this.exactPattern = this.addCheckBox(this.processingPattern.x + this.processingPattern.getWidth() + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, I18n.func_135052_a((String)"misc.refinedstorage.exact", (Object[])new Object[0]), GridTile.EXACT_PATTERN.getValue(), btn -> TileDataManager.setParameter(GridTile.EXACT_PATTERN, this.exactPattern.isChecked()));
            }
            this.addSideButton(new TypeSideButton(this, GridTile.PROCESSING_TYPE));
        }
        this.updateScrollbar();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void setView(IGridView view) {
        this.view = view;
    }

    public IGridView getView() {
        return this.view;
    }

    @Override
    public void tick(int x, int y) {
        if (this.wasConnected != this.grid.isGridActive()) {
            this.wasConnected = this.grid.isGridActive();
            this.view.sort();
        }
        if (GridScreen.isKeyDown(RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX)) {
            RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
        }
        this.tabs.update();
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        if (this.grid.getGridType() == GridType.CRAFTING) {
            return 156;
        }
        if (this.grid.getGridType() == GridType.PATTERN) {
            return 169;
        }
        return 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getTopHeight() + this.getVisibleRows() * 18;
        if (this.grid.getGridType() == GridType.NORMAL || this.grid.getGridType() == GridType.FLUID) {
            yp += 16;
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            yp += 73;
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            yp += 86;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField.func_146179_b();
    }

    @Override
    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.height - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.CLIENT_CONFIG.getGrid().getMaxRowsStretch()));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    private boolean isOverSlotWithStack() {
        return this.grid.isGridActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(double mouseX, double mouseY) {
        return RenderUtils.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    private boolean isOverClear(double mouseX, double mouseY) {
        int y = this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getGridType()) {
            case CRAFTING: {
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                if (((GridNetworkNode)this.grid).isProcessingPattern()) {
                    return RenderUtils.inBounds(154, y, 7, 7, mouseX, mouseY);
                }
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(double mouseX, double mouseY) {
        return this.grid.getGridType() == GridType.PATTERN && RenderUtils.inBounds(172, this.getTopHeight() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((GridNetworkNode)this.grid).canCreatePattern();
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.tabs.drawBackground(x, y - this.tabs.getHeight());
        if (this.grid instanceof IPortableGrid) {
            this.bindTexture("refinedstorage", "gui/portable_grid.png");
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            this.bindTexture("refinedstorage", "gui/crafting_grid.png");
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.bindTexture("refinedstorage", "gui/pattern_grid" + (((GridNetworkNode)this.grid).isProcessingPattern() ? "_processing" : "") + ".png");
        } else {
            this.bindTexture("refinedstorage", "gui/grid.png");
        }
        int yy = y;
        this.blit(x, yy, 0, 0, this.field_146999_f - 34, this.getTopHeight());
        this.blit(x + this.field_146999_f - 34 + 4, y, 197, 0, 30, this.grid instanceof IPortableGrid ? 114 : 82);
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            this.blit(x, yy += 18, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.field_146999_f - 34, 18);
        }
        this.blit(x, yy += 18, 0, this.getTopHeight() + 54, this.field_146999_f - 34, this.getBottomHeight());
        if (this.grid.getGridType() == GridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((GridNetworkNode)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.blit(x + 172, y + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
        }
        this.tabs.drawForeground(x, y - this.tabs.getHeight(), mouseX, mouseY, true);
        this.searchField.render(0, 0, 0.0f);
        this.scrollbar.render();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.isOverSlotWithStack()) {
            this.drawGridTooltip(this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        this.renderString(7, this.getYPlayerInventory() - 12, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        int x = 8;
        int y = 19;
        this.slotNumber = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                this.slotNumber = slot;
            }
            if (slot < this.view.getStacks().size()) {
                this.view.getStacks().get(slot).draw(this, x, y);
            }
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                int color = this.grid.isGridActive() ? -2130706433 : -10790053;
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.fillGradient(x, y, x + 16, y + 16, color, color);
                GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.renderTooltip(mouseX, mouseY, I18n.func_135052_a((String)"misc.refinedstorage.clear", (Object[])new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.renderTooltip(mouseX, mouseY, I18n.func_135052_a((String)"gui.refinedstorage.grid.pattern_create", (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(this.font, mouseX, mouseY);
    }

    private void drawGridTooltip(IGridStack gridStack, int mouseX, int mouseY) {
        ArrayList textLines = Lists.newArrayList((Object[])gridStack.getTooltip().split("\n"));
        ArrayList smallTextLines = Lists.newArrayList();
        if (!gridStack.isCraftable()) {
            smallTextLines.add(I18n.func_135052_a((String)"misc.refinedstorage.total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}));
        }
        if (gridStack.getTrackerEntry() != null) {
            smallTextLines.add(TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName()));
        }
        ItemStack stack = gridStack instanceof ItemGridStack ? ((ItemGridStack)gridStack).getStack() : ItemStack.field_190927_a;
        RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, RS.CLIENT_CONFIG.getGrid().getDetailedTooltip(), stack, mouseX, mouseY, this.field_146999_f, this.field_147000_g, this.font);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        boolean clickedCreatePattern;
        if (this.tabs.mouseClicked()) {
            return true;
        }
        if (this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (RS.CLIENT_CONFIG.getGrid().getPreventSortingWhileShiftIsDown()) {
            this.doSort = !this.isOverSlotArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r) && !this.isOverCraftingOutputArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        if (clickedCreatePattern) {
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            RS.NETWORK_HANDLER.sendToServer(new GridPatternCreateMessage(((GridNetworkNode)this.grid).getPos()));
            return true;
        }
        if (this.grid.isGridActive()) {
            if (clickedClear) {
                this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
                return true;
            }
            ItemStack held = ((GridContainer)this.field_147002_h).getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r) && !held.func_190926_b() && (clickedButton == 0 || clickedButton == 1)) {
                if (this.grid.getGridType() == GridType.FLUID) {
                    RS.NETWORK_HANDLER.sendToServer(new GridFluidInsertHeldMessage());
                } else {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemInsertHeldMessage(clickedButton == 1));
                }
                return true;
            }
            if (this.isOverSlotWithStack()) {
                boolean isMiddleClickPulling = !held.func_190926_b() && clickedButton == 2;
                boolean isPulling = held.func_190926_b() || isMiddleClickPulling;
                IGridStack stack = this.view.getStacks().get(this.slotNumber);
                if (isPulling) {
                    if (this.view.canCraft() && stack.isCraftable()) {
                        this.minecraft.func_147108_a((Screen)new CraftingSettingsScreen(this, this.field_213127_e.field_70458_d, stack));
                    } else if (this.view.canCraft() && !stack.isCraftable() && stack.getOtherId() != null && GridScreen.hasShiftDown() && GridScreen.hasControlDown()) {
                        this.minecraft.func_147108_a((Screen)new CraftingSettingsScreen(this, this.field_213127_e.field_70458_d, this.view.get(stack.getOtherId())));
                    } else if (this.grid.getGridType() == GridType.FLUID && held.func_190926_b()) {
                        RS.NETWORK_HANDLER.sendToServer(new GridFluidPullMessage(this.view.getStacks().get(this.slotNumber).getId(), GridScreen.hasShiftDown()));
                    } else if (this.grid.getGridType() != GridType.FLUID) {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GridScreen.hasShiftDown()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        RS.NETWORK_HANDLER.sendToServer(new GridItemPullMessage(stack.getId(), flags));
                    }
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    private boolean isOverCraftingOutputArea(double mouseX, double mouseY) {
        if (this.grid.getGridType() != GridType.CRAFTING) {
            return false;
        }
        return RenderUtils.inBounds(130, this.getTopHeight() + this.getVisibleRows() * 18 + 18, 24, 24, mouseX, mouseY);
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return this.scrollbar.mouseScrolled(x, y, delta) || super.mouseScrolled(x, y, delta);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean func_223281_a_(int key, int p_223281_2_, int p_223281_3_) {
        if (key == 340 || key == 344) {
            this.view.sort();
        }
        return super.func_223281_a_(key, p_223281_2_, p_223281_3_);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchField.keyPressed(key, scanCode, modifiers) || this.searchField.func_212955_f()) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public SearchWidget getSearchField() {
        return this.searchField;
    }

    public void updateExactPattern(boolean checked) {
        if (this.exactPattern != null) {
            this.exactPattern.setIsChecked(checked);
        }
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    public boolean canSort() {
        return this.doSort || !GridScreen.hasShiftDown();
    }

    public static List<IGridSorter> getSorters() {
        LinkedList<IGridSorter> sorters = new LinkedList<IGridSorter>();
        sorters.add(GridScreen.getDefaultSorter());
        sorters.add(new QuantityGridSorter());
        sorters.add(new IdGridSorter());
        sorters.add(new LastModifiedGridSorter());
        sorters.add(new InventoryTweaksGridSorter());
        return sorters;
    }

    public static IGridSorter getDefaultSorter() {
        return new NameGridSorter();
    }
}

