/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSTiles;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.DiskState;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.DiskManipulatorNetworkNode;
import com.raoulvdberge.refinedstorage.tile.NetworkNodeTile;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.config.IWhitelistBlacklist;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DiskManipulatorTile
extends NetworkNodeTile<DiskManipulatorNetworkNode> {
    public static final TileDataParameter<Integer, DiskManipulatorTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, DiskManipulatorTile> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final TileDataParameter<Integer, DiskManipulatorTile> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer, DiskManipulatorTile> IO_MODE = new TileDataParameter<Integer, DiskManipulatorTile>(DataSerializers.field_187192_b, 0, t -> ((DiskManipulatorNetworkNode)t.getNode()).getIoMode(), (t, v) -> {
        ((DiskManipulatorNetworkNode)t.getNode()).setIoMode((int)v);
        ((DiskManipulatorNetworkNode)t.getNode()).markDirty();
    });
    public static final ModelProperty<DiskState[]> DISK_STATE_PROPERTY = new ModelProperty();
    private static final String NBT_DISK_STATE = "DiskStates";
    private LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((DiskManipulatorNetworkNode)this.getNode()).getDisks());
    private DiskState[] diskState = new DiskState[8];

    public DiskManipulatorTile() {
        super(RSTiles.DISK_MANIPULATOR);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(IO_MODE);
        Arrays.fill((Object[])this.diskState, (Object)DiskState.NONE);
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        ListNBT list = new ListNBT();
        for (DiskState state : ((DiskManipulatorNetworkNode)this.getNode()).getDiskState()) {
            list.add((Object)new IntNBT(state.ordinal()));
        }
        tag.func_218657_a(NBT_DISK_STATE, (INBT)list);
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        super.readUpdate(tag);
        ListNBT list = tag.func_150295_c(NBT_DISK_STATE, 3);
        for (int i = 0; i < list.size(); ++i) {
            this.diskState[i] = DiskState.values()[list.func_186858_c(i)];
        }
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DISK_STATE_PROPERTY, (Object)this.diskState).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public DiskManipulatorNetworkNode createNode(World world, BlockPos pos) {
        return new DiskManipulatorNetworkNode(world, pos);
    }
}

