/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSTiles;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkTransmitterNetworkNode;
import com.raoulvdberge.refinedstorage.tile.NetworkNodeTile;
import com.raoulvdberge.refinedstorage.tile.data.RSSerializers;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class NetworkTransmitterTile
extends NetworkNodeTile<NetworkTransmitterNetworkNode> {
    public static final TileDataParameter<Integer, NetworkTransmitterTile> DISTANCE = new TileDataParameter<Integer, NetworkTransmitterTile>(DataSerializers.field_187192_b, 0, t -> ((NetworkTransmitterNetworkNode)t.getNode()).getDistance());
    public static final TileDataParameter<Optional<ResourceLocation>, NetworkTransmitterTile> RECEIVER_DIMENSION = new TileDataParameter<Optional, NetworkTransmitterTile>(RSSerializers.OPTIONAL_RESOURCE_LOCATION_SERIALIZER, Optional.empty(), t -> {
        if (((NetworkTransmitterNetworkNode)t.getNode()).getReceiverDimension() != null) {
            return Optional.of(((NetworkTransmitterNetworkNode)t.getNode()).getReceiverDimension().getRegistryName());
        }
        return Optional.empty();
    });
    private LazyOptional<IItemHandler> networkCardCapability = LazyOptional.of(() -> ((NetworkTransmitterNetworkNode)this.getNode()).getNetworkCard());

    public NetworkTransmitterTile() {
        super(RSTiles.NETWORK_TRANSMITTER);
        this.dataManager.addWatchedParameter(DISTANCE);
        this.dataManager.addWatchedParameter(RECEIVER_DIMENSION);
    }

    @Override
    @Nonnull
    public NetworkTransmitterNetworkNode createNode(World world, BlockPos pos) {
        return new NetworkTransmitterNetworkNode(world, pos);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.networkCardCapability.cast();
        }
        return super.getCapability(cap, direction);
    }
}

