/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSTiles;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.StorageMonitorNetworkNode;
import com.raoulvdberge.refinedstorage.tile.NetworkNodeTile;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StorageMonitorTile
extends NetworkNodeTile<StorageMonitorNetworkNode> {
    public static final TileDataParameter<Integer, StorageMonitorTile> COMPARE = IComparable.createParameter();
    private static final String NBT_STACK = "Stack";
    private static final String NBT_AMOUNT = "Amount";
    private int amount;
    @Nullable
    private ItemStack itemStack;

    public StorageMonitorTile() {
        super(RSTiles.STORAGE_MONITOR);
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public StorageMonitorNetworkNode createNode(World world, BlockPos pos) {
        return new StorageMonitorNetworkNode(world, pos);
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        ItemStack stack = ((StorageMonitorNetworkNode)this.getNode()).getItemFilters().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            tag.func_218657_a(NBT_STACK, (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        tag.func_74768_a(NBT_AMOUNT, ((StorageMonitorNetworkNode)this.getNode()).getAmount());
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        super.readUpdate(tag);
        this.itemStack = tag.func_74764_b(NBT_STACK) ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(NBT_STACK)) : null;
        this.amount = tag.func_74762_e(NBT_AMOUNT);
    }

    public int getAmount() {
        return this.amount;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

