/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.capability.NetworkNodeProxyCapability;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkUtils {
    @Nullable
    public static INetworkNode getNodeFromTile(@Nullable TileEntity tile) {
        INetworkNodeProxy proxy;
        if (tile != null && (proxy = (INetworkNodeProxy)tile.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY).orElse(null)) != null) {
            return proxy.getNode();
        }
        return null;
    }

    @Nullable
    public static INetwork getNetworkFromNode(@Nullable INetworkNode node) {
        if (node != null) {
            return node.getNetwork();
        }
        return null;
    }

    public static boolean attemptModify(World world, BlockPos pos, Direction facing, PlayerEntity player, Runnable action) {
        return NetworkUtils.attempt(world, pos, facing, player, action, Permission.MODIFY);
    }

    public static boolean attempt(World world, BlockPos pos, Direction facing, PlayerEntity player, Runnable action, Permission ... permissionsRequired) {
        if (world.field_72995_K) {
            return true;
        }
        INetwork network = NetworkUtils.getNetworkFromNode(NetworkUtils.getNodeFromTile(world.func_175625_s(pos)));
        if (network != null) {
            for (Permission permission : permissionsRequired) {
                if (network.getSecurityManager().hasPermission(permission, player)) continue;
                WorldUtils.sendNoPermissionMessage(player);
                return true;
            }
        }
        action.run();
        return true;
    }
}

