/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public final class RenderUtils {
    private static final VertexFormat ITEM_FORMAT_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);

    public static String shorten(String text, int length) {
        if (text.length() > length) {
            text = text.substring(0, length) + "...";
        }
        return text;
    }

    public static int getOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }

    public static void addCombinedItemsToTooltip(List<ITextComponent> tooltip, boolean displayAmount, List<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b() || combinedIndices.contains(i)) continue;
            ItemStack stack = stacks.get(i);
            ITextComponent data = stack.func_200301_q();
            int amount = stack.func_190916_E();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j))) continue;
                amount += stacks.get(j).func_190916_E();
                combinedIndices.add(j);
            }
            if (displayAmount) {
                data = new StringTextComponent(amount + "x ").func_150257_a(data);
            }
            tooltip.add(data.func_150255_a(Styles.GRAY));
        }
    }

    public static void addCombinedFluidsToTooltip(List<ITextComponent> tooltip, boolean displayMb, List<FluidStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).isEmpty() || combinedIndices.contains(i)) continue;
            FluidStack stack = stacks.get(i);
            ITextComponent data = stack.getDisplayName();
            int amount = stack.getAmount();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j), 1)) continue;
                amount += stacks.get(j).getAmount();
                combinedIndices.add(j);
            }
            if (displayMb) {
                data = new StringTextComponent(API.instance().getQuantityFormatter().formatInBucketForm(amount) + " ").func_150257_a(data);
            }
            tooltip.add(data.func_150255_a(Styles.GRAY));
        }
    }

    public static void drawTooltipWithSmallText(List<String> textLines, List<String> smallTextLines, boolean showSmallText, @Nonnull ItemStack stack, int mouseX, int mouseY, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
        if (!textLines.isEmpty()) {
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mouseX, mouseY, screenWidth, screenHeight, -1, fontRenderer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            FontRenderer font = event.getFontRenderer();
            float textScale = Minecraft.func_71410_x().func_211821_e() ? 1.0f : 0.7f;
            GlStateManager.disableRescaleNormal();
            RenderHelper.func_74518_a();
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            int tooltipTextWidth = 0;
            for (String string : textLines) {
                int textLineWidth = font.func_78256_a(string);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            if (showSmallText) {
                for (String smallText : smallTextLines) {
                    int size = (int)((float)font.func_78256_a(smallText) * textScale);
                    if (size <= tooltipTextWidth) continue;
                    tooltipTextWidth = size;
                }
            }
            int titleLinesCount = 1;
            int n = mouseX + 12;
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (showSmallText) {
                tooltipHeight += smallTextLines.size() * 10;
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY - 4), (int)(n + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY + tooltipHeight + 3), (int)(n + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY - 3), (int)(n + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(n - 4), (int)(tooltipY - 3), (int)(n - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(n + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(n + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY - 3 + 1), (int)(n - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(n + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(n + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY - 3), (int)(n + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF, (int)0x505000FF);
            GuiUtils.drawGradientRect((int)300, (int)(n - 3), (int)(tooltipY + tooltipHeight + 2), (int)(n + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847, (int)1344798847);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, n, tooltipY, font, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                font.func_175063_a(line, (float)n, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, n, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            if (showSmallText) {
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)textScale, (float)textScale, (float)1.0f);
                int y = tooltipTop + tooltipHeight - 6;
                for (int i = smallTextLines.size() - 1; i >= 0; --i) {
                    font.func_175063_a(TextFormatting.GRAY + smallTextLines.get(i), (float)RenderUtils.getOffsetOnScale(n, textScale), (float)RenderUtils.getOffsetOnScale(y - (Minecraft.func_71410_x().func_211821_e() ? 2 : 0), textScale), -1);
                    y -= 9;
                }
                GlStateManager.popMatrix();
            }
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
            RenderHelper.func_74519_b();
            GlStateManager.enableRescaleNormal();
        }
    }

    public static List<String> getTooltipFromItem(ItemStack stack) {
        List tooltip = stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList tooltipStrings = Lists.newArrayList();
        for (ITextComponent itextcomponent : tooltip) {
            tooltipStrings.add(itextcomponent.func_150254_d());
        }
        return tooltipStrings;
    }

    public static boolean isLightMapDisabled() {
        return (Boolean)ForgeConfig.CLIENT.forgeLightPipelineEnabled.get() == false;
    }

    public static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (RenderUtils.isLightMapDisabled()) {
            return format;
        }
        if (format == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (format == DefaultVertexFormats.field_176599_b) {
            return ITEM_FORMAT_WITH_LIGHTMAP;
        }
        if (!format.func_207750_a(1)) {
            VertexFormat result = new VertexFormat(format);
            result.func_181721_a(DefaultVertexFormats.field_181716_p);
            return result;
        }
        return format;
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }
}

