/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidator;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.NetworkCardItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.IItemHandler;

public class NetworkTransmitterNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "network_transmitter");
    private BaseItemHandler networkCard = new BaseItemHandler(1).addValidator(new ItemValidator(RSItems.NETWORK_CARD)).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        ItemStack card = handler.getStackInSlot(slot);
        if (card.func_190926_b()) {
            this.receiver = null;
            this.receiverDimension = null;
        } else {
            this.receiver = NetworkCardItem.getReceiver(card);
            this.receiverDimension = NetworkCardItem.getDimension(card);
        }
        if (this.network != null) {
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getWorld(), this.network.getPosition());
        }
    });
    private BlockPos receiver;
    private DimensionType receiverDimension;

    public NetworkTransmitterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, 0, tag);
        return tag;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.networkCard, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getNetworkTransmitter().getUsage();
    }

    public BaseItemHandler getNetworkCard() {
        return this.networkCard;
    }

    @Override
    public IItemHandler getDrops() {
        return this.networkCard;
    }

    @Nullable
    public BlockPos getReceiver() {
        return this.receiver;
    }

    @Nullable
    public DimensionType getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null || this.receiverDimension == null || !this.isSameDimension()) {
            return -1;
        }
        return (int)Math.sqrt(Math.pow(this.pos.func_177958_n() - this.receiver.func_177958_n(), 2.0) + Math.pow(this.pos.func_177956_o() - this.receiver.func_177956_o(), 2.0) + Math.pow(this.pos.func_177952_p() - this.receiver.func_177952_p(), 2.0));
    }

    public boolean isSameDimension() {
        return this.world.func_201675_m().func_186058_p() == this.receiverDimension;
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.receiverDimension != null;
    }

    @Override
    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                return;
            }
            operator.apply(this.world, this.receiver, null);
        }
    }
}

