/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.container.FilterContainer;
import com.raoulvdberge.refinedstorage.item.FilterItem;
import com.raoulvdberge.refinedstorage.util.PacketBufferUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class FilterUpdateMessage {
    private int compare;
    private int mode;
    private boolean modFilter;
    private String name;
    private int type;

    public FilterUpdateMessage(int compare, int mode, boolean modFilter, String name, int type) {
        this.compare = compare;
        this.mode = mode;
        this.modFilter = modFilter;
        this.name = name;
        this.type = type;
    }

    public static FilterUpdateMessage decode(PacketBuffer buf) {
        return new FilterUpdateMessage(buf.readInt(), buf.readInt(), buf.readBoolean(), PacketBufferUtils.readString(buf), buf.readInt());
    }

    public static void encode(FilterUpdateMessage message, PacketBuffer buf) {
        buf.writeInt(message.compare);
        buf.writeInt(message.mode);
        buf.writeBoolean(message.modFilter);
        buf.func_180714_a(message.name);
        buf.writeInt(message.type);
    }

    public static void handle(FilterUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null && player.field_71070_bA instanceof FilterContainer) {
            ctx.get().enqueueWork(() -> FilterUpdateMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, FilterUpdateMessage message) {
        FilterItem.setCompare(((FilterContainer)player.field_71070_bA).getStack(), message.compare);
        FilterItem.setMode(((FilterContainer)player.field_71070_bA).getStack(), message.mode);
        FilterItem.setModFilter(((FilterContainer)player.field_71070_bA).getStack(), message.modFilter);
        FilterItem.setName(((FilterContainer)player.field_71070_bA).getStack(), message.name);
        FilterItem.setType(((FilterContainer)player.field_71070_bA).getStack(), message.type);
    }
}

