/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SecurityManagerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.SecurityManagerTile;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SecurityManagerUpdateMessage {
    private BlockPos pos;
    private Permission permission;
    private boolean state;

    public SecurityManagerUpdateMessage(BlockPos pos, Permission permission, boolean state) {
        this.pos = pos;
        this.permission = permission;
        this.state = state;
    }

    public static SecurityManagerUpdateMessage decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        int id = buf.readInt();
        Permission permission = Permission.INSERT;
        for (Permission otherPermission : Permission.values()) {
            if (otherPermission.getId() != id) continue;
            permission = otherPermission;
            break;
        }
        boolean state = buf.readBoolean();
        return new SecurityManagerUpdateMessage(pos, permission, state);
    }

    public static void encode(SecurityManagerUpdateMessage message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeInt(message.permission.getId());
        buf.writeBoolean(message.state);
    }

    public static void handle(SecurityManagerUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> SecurityManagerUpdateMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, SecurityManagerUpdateMessage message) {
        TileEntity tile = player.func_130014_f_().func_175625_s(message.pos);
        if (tile instanceof SecurityManagerTile) {
            ((SecurityManagerNetworkNode)((SecurityManagerTile)tile).getNode()).updatePermission(message.permission, message.state);
        }
    }
}

