/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridItemPullMessage {
    private UUID id;
    private int flags;

    public GridItemPullMessage(UUID id, int flags) {
        this.id = id;
        this.flags = flags;
    }

    public static GridItemPullMessage decode(PacketBuffer buf) {
        return new GridItemPullMessage(buf.func_179253_g(), buf.readInt());
    }

    public static void encode(GridItemPullMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.id);
        buf.writeInt(message.flags);
    }

    public static void handle(GridItemPullMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                IGrid grid;
                Container container = player.field_71070_bA;
                if (container instanceof GridContainer && (grid = ((GridContainer)container).getGrid()).getItemHandler() != null) {
                    grid.getItemHandler().onExtract(player, message.id, message.flags);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

