/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.filtering;

import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.screen.grid.stack.FluidGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FilterGridFilter
implements Predicate<IGridStack> {
    private List<IFilter> filters;

    public FilterGridFilter(List<IFilter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean test(IGridStack stack) {
        if (this.filters.isEmpty()) {
            return true;
        }
        int lastMode = 0;
        for (IFilter filter : this.filters) {
            String stackInFilterModId;
            ResourceLocation stackInFilterRegistryName;
            ItemStack stackInFilter;
            lastMode = filter.getMode();
            if (stack instanceof ItemGridStack && filter.getStack() instanceof ItemStack) {
                stackInFilter = (ItemStack)filter.getStack();
                if (filter.isModFilter()) {
                    String stackModId = stack.getModId();
                    String filterModId = stackInFilter.func_77973_b().getCreatorModId(stackInFilter);
                    if (filterModId == null || !filterModId.equals(stackModId)) continue;
                    return filter.getMode() == 0;
                }
                if (!API.instance().getComparer().isEqual(((ItemGridStack)stack).getStack(), stackInFilter, filter.getCompare())) continue;
                return filter.getMode() == 0;
            }
            if (!(stack instanceof FluidGridStack) || !(filter.getStack() instanceof FluidStack)) continue;
            stackInFilter = (FluidStack)filter.getStack();
            if (!(filter.isModFilter() ? (stackInFilterRegistryName = stackInFilter.getFluid().getRegistryName()) != null && (stackInFilterModId = stackInFilterRegistryName.func_110624_b()).equalsIgnoreCase(stack.getModId()) : API.instance().getComparer().isEqual(((FluidGridStack)stack).getStack(), (FluidStack)stackInFilter, filter.getCompare()))) continue;
            return filter.getMode() == 0;
        }
        return lastMode != 0;
    }
}

