/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.respawnablepets.common.handler;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import moriyashiine.respawnablepets.RespawnablePets;
import moriyashiine.respawnablepets.common.network.SmokePuffMessage;
import moriyashiine.respawnablepets.common.registry.RPItems;
import moriyashiine.respawnablepets.common.world.RPWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class PetHandler {
    private static final ITeleporter NO_PORTAL = new ITeleporter(){

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }
    };
    private static final EntityTypeTags.Wrapper BLACKLISTED = new EntityTypeTags.Wrapper(new ResourceLocation("respawnablepets", "blacklisted"));

    @SubscribeEvent
    public void togglePetRespawn(LivingAttackEvent event) {
        PlayerEntity player;
        Entity attacker;
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof PlayerEntity) && (attacker = event.getSource().func_76364_f()) instanceof PlayerEntity && (player = (PlayerEntity)attacker).func_184614_ca().func_77973_b() == RPItems.etheric_gem) {
            event.setCanceled(true);
            if (entity.serializeNBT().func_74779_i("OwnerUUID").equals(player.func_110124_au().toString())) {
                if (BLACKLISTED.func_199685_a_(entity.func_200600_R())) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.respawnablepets.blacklisted", new Object[]{entity.func_145748_c_()}), true);
                } else {
                    RPWorld rpworld = RPWorld.get(world);
                    if (PetHandler.isPetRespawnable(rpworld, entity)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.respawnablepets.disable_respawn", new Object[]{entity.func_145748_c_()}), true);
                        for (int i = rpworld.petsToRespawn.size() - 1; i >= 0; --i) {
                            if (!rpworld.petsToRespawn.get(i).equals(entity.func_110124_au())) continue;
                            rpworld.petsToRespawn.remove(i);
                            rpworld.func_76185_a();
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.respawnablepets.enable_respawn", new Object[]{entity.func_145748_c_()}), true);
                        rpworld.petsToRespawn.add(entity.func_110124_au());
                        rpworld.func_76185_a();
                    }
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.respawnablepets.not_owner", new Object[]{entity.func_145748_c_()}), true);
            }
        }
    }

    @SubscribeEvent
    public void respawnPets(PlayerWakeUpEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            RPWorld rpworld = RPWorld.get(world);
            for (int i = rpworld.storedPets.size() - 1; i >= 0; --i) {
                LivingEntity pet;
                CompoundNBT nbt = rpworld.storedPets.get(i);
                if (!player.func_110124_au().equals(UUID.fromString(nbt.func_74779_i("OwnerUUID"))) || (pet = (LivingEntity)((EntityType)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.func_74779_i("id"))))).func_200721_a(world)) == null) continue;
                pet.deserializeNBT(nbt);
                pet.changeDimension(player.field_71093_bK, NO_PORTAL);
                pet.func_70080_a(player.func_226277_ct_() + 0.5, player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, (float)world.field_73012_v.nextInt(360), 0.0f);
                pet.field_70128_L = false;
                pet.func_70606_j(pet.func_110138_aP());
                pet.func_70066_B();
                pet.func_195061_cb();
                pet.field_70143_R = 0.0f;
                world.func_217376_c((Entity)pet);
                rpworld.storedPets.remove(i);
                rpworld.func_76185_a();
            }
        }
    }

    @SubscribeEvent
    public void storePet(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof PlayerEntity)) {
            RPWorld rpworld = RPWorld.get(world);
            if (entity.func_110143_aJ() - event.getAmount() <= 0.0f && PetHandler.isPetRespawnable(rpworld, entity)) {
                event.setCanceled(true);
                rpworld.storedPets.add(entity.serializeNBT());
                rpworld.func_76185_a();
                RespawnablePets.NETWORK_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (double)32.0, (DimensionType)entity.field_71093_bK)), (Object)new SmokePuffMessage(entity.func_145782_y()));
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                entity.func_70106_y();
                PlayerEntity owner = PetHandler.findPlayer(world, UUID.fromString(entity.serializeNBT().func_74779_i("OwnerUUID")));
                if (owner != null && world.func_82736_K().func_223586_b(GameRules.field_223609_l)) {
                    owner.func_145747_a(entity.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    private static PlayerEntity findPlayer(World world, UUID uuid) {
        for (ServerWorld serverWorld : Objects.requireNonNull(world.func_73046_m()).func_212370_w()) {
            PlayerEntity player = serverWorld.func_217371_b(uuid);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    private static boolean isPetRespawnable(RPWorld rpworld, LivingEntity entity) {
        for (UUID uuid : rpworld.petsToRespawn) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

