/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samssaplings;

import com.lothrazar.samssaplings.SaplingDespawnGrowth;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="samssaplings", useMetadata=true)
public class ModSaplings {
    public static final String MODID = "samssaplings";
    @Mod.Instance(value="samssaplings")
    public static ModSaplings instance;
    public static Logger logger;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        SaplingDespawnGrowth.plantDespawningSaplings = config.getBoolean("sapling_plant_despawn", MODID, true, "When a sapling (or mushroom) despawns while sitting on grass or dirt, it will instead attempt to plant itself.");
        SaplingDespawnGrowth.drop_on_failed_growth = config.getBoolean("drop_on_failed_growth", MODID, true, "When a sapling fails to grow and turns to a dead bush, if this is true than the sapling item will also drop on the ground.");
        String category = "sapling_biome_map";
        config.addCustomCategoryComment(category, "A list of biome IDs that each sapling is allowed to grow in.  ");
        String oakCSV = config.get(category, "oak", "4, 18, 132, 39, 166, 167, 21, 23, 151, 149, 22, 6, 134, 3, 20, 34, 12, 29, 157").getString();
        SaplingDespawnGrowth.oakBiomes = this.csvToInt(oakCSV);
        String acaciaCSV = config.get(category, "acacia", "35, 36, 38, 163, 164").getString();
        SaplingDespawnGrowth.acaciaBiomes = this.csvToInt(acaciaCSV);
        String spruceCSV = config.get(category, "spruce", "5, 19, 32, 160, 161, 33, 30, 31, 158, 3, 20, 34, 21, 12, 13").getString();
        SaplingDespawnGrowth.spruceBiomes = this.csvToInt(spruceCSV);
        String birchCSV = config.get(category, "birch", "27, 28, 155, 156, 4, 18, 132, 29, 157").getString();
        SaplingDespawnGrowth.birchBiomes = this.csvToInt(birchCSV);
        String darkCSV = config.get(category, "dark_oak", "29, 157").getString();
        SaplingDespawnGrowth.darkoakBiomes = this.csvToInt(darkCSV);
        String jungleCSV = config.get(category, "jungle", "21, 23, 22, 149, 151").getString();
        SaplingDespawnGrowth.jungleBiomes = this.csvToInt(jungleCSV);
        if (config.hasChanged()) {
            config.save();
        }
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(new SaplingDespawnGrowth());
        handlers.add(instance);
        for (Object e : handlers) {
            FMLCommonHandler.instance().bus().register(e);
            MinecraftForge.EVENT_BUS.register(e);
            MinecraftForge.TERRAIN_GEN_BUS.register(e);
            MinecraftForge.ORE_GEN_BUS.register(e);
        }
    }

    private ArrayList<Integer> csvToInt(String csv) {
        String[] list;
        ArrayList<Integer> bi = new ArrayList<Integer>();
        for (String s_id : list = csv.split(",")) {
            try {
                int biome = Integer.parseInt(s_id.trim());
                bi.add(biome);
            }
            catch (Exception e) {
                logger.log(Level.WARN, "Invalid biome id from config file, must be integer: " + s_id);
            }
        }
        return bi;
    }

    public static EntityItem dropItemStackInWorld(World worldObj, double x, double y, double z, Block block) {
        return ModSaplings.dropItemStackInWorld(worldObj, x, y, z, new ItemStack(block));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, double x, double y, double z, Item item) {
        return ModSaplings.dropItemStackInWorld(worldObj, x, y, z, new ItemStack(item));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, double x, double y, double z, ItemStack stack) {
        EntityItem entityItem = new EntityItem(worldObj, x, y, z, stack);
        if (!worldObj.field_72995_K) {
            worldObj.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }
}

