/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samssaplings;

import com.lothrazar.samssaplings.ModSaplings;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;

public class SaplingDespawnGrowth {
    public static List<Integer> oakBiomes = new ArrayList<Integer>();
    public static List<Integer> spruceBiomes = new ArrayList<Integer>();
    public static List<Integer> birchBiomes = new ArrayList<Integer>();
    public static List<Integer> jungleBiomes = new ArrayList<Integer>();
    public static List<Integer> darkoakBiomes = new ArrayList<Integer>();
    public static List<Integer> acaciaBiomes = new ArrayList<Integer>();
    public static boolean drop_on_failed_growth;
    public static boolean plantDespawningSaplings;
    private static final int sapling_oak = 0;
    private static final int sapling_spruce = 1;
    private static final int sapling_birch = 2;
    private static final int sapling_jungle = 3;
    private static final int sapling_acacia = 4;
    private static final int sapling_darkoak = 5;

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        Block b = event.world.func_147439_a(event.x, event.y, event.z);
        boolean treeAllowedToGrow = false;
        if (b == Blocks.field_150345_g) {
            int meta = event.world.func_72805_g(event.x, event.y, event.z);
            int biomeID = event.world.func_72807_a((int)event.x, (int)event.z).field_76756_M;
            int growth_data = 8;
            int tree_type = meta - growth_data;
            switch (tree_type) {
                case 4: {
                    treeAllowedToGrow = acaciaBiomes.contains(biomeID);
                    break;
                }
                case 1: {
                    treeAllowedToGrow = spruceBiomes.contains(biomeID);
                    break;
                }
                case 0: {
                    treeAllowedToGrow = oakBiomes.contains(biomeID);
                    break;
                }
                case 2: {
                    treeAllowedToGrow = birchBiomes.contains(biomeID);
                    break;
                }
                case 5: {
                    treeAllowedToGrow = darkoakBiomes.contains(biomeID);
                    break;
                }
                case 3: {
                    treeAllowedToGrow = jungleBiomes.contains(biomeID);
                }
            }
            if (!treeAllowedToGrow) {
                event.setResult(Event.Result.DENY);
                event.world.func_147449_b(event.x, event.y, event.z, (Block)Blocks.field_150330_I);
                if (drop_on_failed_growth) {
                    ModSaplings.dropItemStackInWorld(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(Blocks.field_150345_g, 1, tree_type));
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent event) {
        if (!plantDespawningSaplings) {
            return;
        }
        ItemStack is = event.entityItem.func_92059_d();
        if (is == null) {
            return;
        }
        int x = (int)event.entityItem.field_70165_t;
        int y = (int)event.entityItem.field_70163_u;
        int z = (int)event.entityItem.field_70161_v;
        Block blockhere = event.entity.field_70170_p.func_147439_a(x, y, z);
        Block blockdown = event.entity.field_70170_p.func_147439_a(x, y - 1, z);
        if (blockhere == Blocks.field_150350_a && blockdown == Blocks.field_150346_d || blockdown == Blocks.field_150349_c) {
            if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150345_g) {
                event.entity.field_70170_p.func_147449_b(x, y, z, Blocks.field_150345_g);
                event.entity.field_70170_p.func_72921_c(x, y, z, is.func_77960_j(), 2);
            } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150337_Q) {
                event.entity.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150337_Q);
            } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150338_P) {
                event.entity.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150338_P);
            }
        }
    }
}

