/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samssaplings;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SaplingDespawnGrowth {
    public static List<Integer> oakBiomes = new ArrayList<Integer>();
    public static List<Integer> spruceBiomes = new ArrayList<Integer>();
    public static List<Integer> birchBiomes = new ArrayList<Integer>();
    public static List<Integer> jungleBiomes = new ArrayList<Integer>();
    public static List<Integer> darkoakBiomes = new ArrayList<Integer>();
    public static List<Integer> acaciaBiomes = new ArrayList<Integer>();
    public static boolean drop_on_failed_growth;
    public static boolean plantDespawningSaplings;
    private static final int sapling_oak = 0;
    private static final int sapling_spruce = 1;
    private static final int sapling_birch = 2;
    private static final int sapling_jungle = 3;
    private static final int sapling_acacia = 4;
    private static final int sapling_darkoak = 5;

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        Block b = event.world.func_180495_p(event.pos).func_177230_c();
        boolean treeAllowedToGrow = false;
        if (b == Blocks.field_150345_g) {
            int meta = Blocks.field_150345_g.func_176201_c(event.world.func_180495_p(event.pos));
            int biomeID = event.world.func_180494_b((BlockPos)event.pos).field_76756_M;
            int growth_data = 8;
            int tree_type = meta - growth_data;
            switch (tree_type) {
                case 4: {
                    treeAllowedToGrow = acaciaBiomes.contains(biomeID);
                    break;
                }
                case 1: {
                    treeAllowedToGrow = spruceBiomes.contains(biomeID);
                    break;
                }
                case 0: {
                    treeAllowedToGrow = oakBiomes.contains(biomeID);
                    break;
                }
                case 2: {
                    treeAllowedToGrow = birchBiomes.contains(biomeID);
                    break;
                }
                case 5: {
                    treeAllowedToGrow = darkoakBiomes.contains(biomeID);
                    break;
                }
                case 3: {
                    treeAllowedToGrow = jungleBiomes.contains(biomeID);
                }
            }
            if (!treeAllowedToGrow) {
                event.setResult(Event.Result.DENY);
                event.world.func_175656_a(event.pos, Blocks.field_150330_I.func_176223_P());
                if (drop_on_failed_growth) {
                    SaplingDespawnGrowth.dropItemStackInWorld(event.world, event.pos, new ItemStack(Blocks.field_150345_g, 1, tree_type));
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent event) {
        if (!plantDespawningSaplings) {
            return;
        }
        ItemStack is = event.entityItem.func_92059_d();
        if (is == null) {
            return;
        }
        Block blockhere = event.entity.field_70170_p.func_180495_p(event.entityItem.func_180425_c()).func_177230_c();
        Block blockdown = event.entity.field_70170_p.func_180495_p(event.entityItem.func_180425_c().func_177977_b()).func_177230_c();
        if (blockhere == Blocks.field_150350_a && blockdown == Blocks.field_150346_d || blockdown == Blocks.field_150349_c) {
            if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150345_g) {
                event.entity.field_70170_p.func_175656_a(event.entityItem.func_180425_c(), Blocks.field_150345_g.func_176203_a(is.func_77952_i()));
            } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150337_Q) {
                event.entity.field_70170_p.func_175656_a(event.entityItem.func_180425_c(), Blocks.field_150337_Q.func_176223_P());
            } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150338_P) {
                event.entity.field_70170_p.func_175656_a(event.entityItem.func_180425_c(), Blocks.field_150338_P.func_176223_P());
            }
        }
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, ItemStack stack) {
        EntityItem entityItem = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        if (!worldObj.field_72995_K) {
            worldObj.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }
}

