/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item;

import com.focamacho.ringsofascension.RingsOfAscension;
import com.focamacho.ringsofascension.init.ModItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;

public abstract class ItemRingBase
extends Item {
    protected String tooltip;

    public ItemRingBase(Item.Properties properties, String name, String tooltip) {
        super(properties.func_200916_a(RingsOfAscension.tabGroup));
        this.setRegistryName(name);
        this.tooltip = tooltip;
        ModItems.allItems.add(this);
    }

    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
    }

    public Multimap<String, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        return modifiers;
    }

    public void onUnequippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public int getTier() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> lazyCurio = LazyOptional.of(() -> new ICurio(){

                public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.tickCurio(identifier, index, livingEntity);
                }

                public void playEquipSound(LivingEntity livingEntity) {
                    livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_180425_c(), SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }

                @Nonnull
                public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                    return ICurio.DropRule.DEFAULT;
                }

                public void onUnequipped(String identifier, LivingEntity livingEntity) {
                    ItemRingBase.this.onUnequippedCurio(identifier, livingEntity);
                }

                public boolean canRightClickEquip() {
                    return true;
                }

                public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
                    return ItemRingBase.this.curioModifiers(stack, identifier);
                }
            });

            public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
                return CuriosCapability.ITEM.orEmpty(capability, this.lazyCurio);
            }
        };
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        switch (this.getTier()) {
            case 0: {
                tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier", new Object[0]).func_150254_d() + " " + ChatFormatting.GREEN + new TranslationTextComponent("tooltip.ringsofascension.tier.common", new Object[0]).func_150254_d()));
                break;
            }
            case 1: {
                tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier", new Object[0]).func_150254_d() + " " + ChatFormatting.BLUE + new TranslationTextComponent("tooltip.ringsofascension.tier.rare", new Object[0]).func_150254_d()));
                break;
            }
            case 2: {
                tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier", new Object[0]).func_150254_d() + " " + ChatFormatting.LIGHT_PURPLE + new TranslationTextComponent("tooltip.ringsofascension.tier.epic", new Object[0]).func_150254_d()));
                break;
            }
            case 3: {
                tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier", new Object[0]).func_150254_d() + " " + ChatFormatting.RED + new TranslationTextComponent("tooltip.ringsofascension.tier.legendary", new Object[0]).func_150254_d()));
            }
        }
        if (this.tooltip == null) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.worn", new Object[0]).func_150254_d()));
        tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.BLUE + new TranslationTextComponent(this.tooltip, new Object[0]).func_150254_d()));
    }
}

