/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import com.github.teamfusion.rottencreatures.common.LootBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1384;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;

public class UndeadMiner
extends class_1642 {
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(UndeadMiner.class, (class_2941)class_2943.field_13327);
    private static final LootBuilder BUILDER = LootBuilder.of("undead_miner");
    public static final class_2960 DIAMOND_LOOT = BUILDER.build("diamond");
    public static final class_2960 IRON_LOOT = BUILDER.build("iron");
    public static final class_2960 STONE_LOOT = BUILDER.build("stone");
    public static final class_2960 GOLD_LOOT = BUILDER.build("gold");

    public UndeadMiner(class_1299<? extends class_1642> type, class_1937 level) {
        super(type, level);
        this.field_6194 = 6;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1642.method_26940().method_26868(class_5134.field_23727, 0.0).method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new class_1384((class_1314)this));
    }

    protected boolean method_7216() {
        return false;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().getId());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.BY_ID[tag.method_10550("Variant")]);
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.field_6011.method_12789(DATA_VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean method_6109() {
        return false;
    }

    protected void method_5964(class_1266 difficulty) {
        super.method_5964(difficulty);
        for (Variant variant : Variant.values()) {
            if (this.getVariant() != variant) continue;
            this.method_5673(class_1304.field_6173, new class_1799((class_1935)variant.getPickaxe()));
        }
    }

    public Variant getRandomVariant(Random random, class_6880<class_1959> biome) {
        int chance = random.nextInt(50);
        if (chance <= 15) {
            return Variant.IRON;
        }
        return chance >= 45 ? Variant.DIAMOND : (biome.method_40220(class_6908.field_36513) ? Variant.GOLD : Variant.STONE);
    }

    protected class_2960 method_5991() {
        return switch (this.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.DIAMOND -> DIAMOND_LOOT;
            case Variant.IRON -> IRON_LOOT;
            case Variant.STONE -> STONE_LOOT;
            case Variant.GOLD -> GOLD_LOOT;
        };
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData, @Nullable class_2487 tag) {
        this.setVariant(this.getRandomVariant(level.method_8409(), (class_6880<class_1959>)level.method_23753(this.method_24515())));
        return super.method_5943(level, difficulty, spawnType, groupData, tag);
    }

    public static boolean checkUndeadMinerSpawnRules(class_1299<UndeadMiner> type, class_5425 level, class_3730 spawnType, class_2338 pos, Random random) {
        return UndeadMiner.method_20680(type, (class_5425)level, (class_3730)spawnType, (class_2338)pos, (Random)random) && (spawnType == class_3730.field_16469 || !level.method_8311(pos));
    }

    public static enum Variant {
        STONE(0, "stone", class_1802.field_8387),
        IRON(1, "iron", class_1802.field_8403),
        DIAMOND(2, "diamond", class_1802.field_8377),
        GOLD(3, "gold", class_1802.field_8335);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final class_1792 pickaxe;

        private Variant(int id, String name, class_1792 pickaxe) {
            this.id = id;
            this.name = name;
            this.pickaxe = pickaxe;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public class_1792 getPickaxe() {
            return this.pickaxe;
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

