/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.worldgen;

import com.github.teamfusion.platform.Environment;
import com.github.teamfusion.platform.common.worldgen.BiomeContext;
import com.github.teamfusion.platform.common.worldgen.BiomeManager;
import com.github.teamfusion.rottencreatures.ConfigEntries;
import com.github.teamfusion.rottencreatures.common.entities.Burned;
import com.github.teamfusion.rottencreatures.common.entities.DeadBeard;
import com.github.teamfusion.rottencreatures.common.entities.Frostbitten;
import com.github.teamfusion.rottencreatures.common.entities.GlacialHunter;
import com.github.teamfusion.rottencreatures.common.entities.Mummy;
import com.github.teamfusion.rottencreatures.common.entities.Swampy;
import com.github.teamfusion.rottencreatures.common.entities.UndeadMiner;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.data.RCBiomeTags;
import com.github.teamfusion.rottencreatures.mixin.access.SpawnPlacementsAccessor;
import java.util.Arrays;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2902;
import net.minecraft.class_5321;

public class WorldGeneration {
    public static void setup() {
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.BURNED.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Burned::checkBurnedSpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.FROSTBITTEN.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Frostbitten::checkFrostbittenSpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.GLACIAL_HUNTER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, GlacialHunter::checkGlacialHunterSpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.SWAMPY.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Swampy::checkSwampySpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.UNDEAD_MINER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, UndeadMiner::checkUndeadMinerSpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.MUMMY.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Mummy::checkMummySpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.SCARAB.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.FLYING_SCARAB.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.DEAD_BEARD.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, DeadBeard::checkDeadBeardSpawnRules);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.ZOMBIE_LACKEY.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.SKELETON_LACKEY.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.IMMORTAL.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        SpawnPlacementsAccessor.callRegister(RCEntityTypes.ZAP.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1308::method_20636);
        BiomeManager.add((writer, biome) -> {
            if (WorldGeneration.in(biome, RCBiomeTags.BURNED) || WorldGeneration.in(biome, (class_5321<class_1959>)class_1972.field_9461)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.BURNED.get(), ConfigEntries.BURNED_WEIGHT.value(), 4, 4);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.FROSTBITTEN) || WorldGeneration.in(biome, class_1959.class_1961.field_9362) || WorldGeneration.in(biome, (class_5321<class_1959>)class_1972.field_9453)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.FROSTBITTEN.get(), ConfigEntries.FROSTBITTEN_WEIGHT.value(), 4, 4);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.GLACIAL_HUNTER) || WorldGeneration.in(biome, class_1959.class_1961.field_9362) || WorldGeneration.in(biome, (class_5321<class_1959>)class_1972.field_9453)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.GLACIAL_HUNTER.get(), ConfigEntries.GLACIAL_HUNTER_WEIGHT.value(), 1, 3);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.SWAMPY) || WorldGeneration.in(biome, class_1959.class_1961.field_9364)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.SWAMPY.get(), ConfigEntries.SWAMPY_WEIGHT.value(), 4, 4);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.UNDEAD_MINER) || WorldGeneration.not(biome, class_1959.class_1961.field_9371, class_1959.class_1961.field_9360, class_1959.class_1961.field_9366, class_1959.class_1961.field_9365)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.UNDEAD_MINER.get(), ConfigEntries.UNDEAD_MINER_WEIGHT.value(), 1, 4);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.MUMMY) || WorldGeneration.in(biome, class_1959.class_1961.field_9368)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.MUMMY.get(), ConfigEntries.MUMMY_WEIGHT.value(), 1, 3);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.DEAD_BEARD) || WorldGeneration.in(biome, class_1959.class_1961.field_9368)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.MUMMY.get(), ConfigEntries.MUMMY_WEIGHT.value(), 1, 3);
            }
            if (WorldGeneration.in(biome, RCBiomeTags.DEAD_BEARD) || WorldGeneration.in(biome, class_1959.class_1961.field_9363)) {
                writer.addSpawn(class_1311.field_6302, RCEntityTypes.DEAD_BEARD.get(), ConfigEntries.DEAD_BEARD_WEIGHT.value(), 1, 1);
            }
        });
    }

    private static boolean in(BiomeContext biome, RCBiomeTags.Spawner spawner) {
        return biome.is(spawner.whitelist()) && !biome.is(spawner.blacklist());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean in(BiomeContext biome, class_1959.class_1961 ... categories) {
        if (!Environment.forge()) return false;
        if (!Arrays.stream(categories).anyMatch(biome::is)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean not(BiomeContext biome, class_1959.class_1961 ... categories) {
        if (!Environment.forge()) return false;
        if (!Arrays.stream(categories).noneMatch(biome::is)) return false;
        return true;
    }

    private static boolean in(BiomeContext context, class_5321<class_1959> biome) {
        return Environment.forge() && context.is(biome);
    }
}

