/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.platform.common.worldgen.forge;

import com.github.teamfusion.platform.common.worldgen.BiomeContext;
import com.github.teamfusion.platform.common.worldgen.BiomeManager;
import com.github.teamfusion.platform.common.worldgen.BiomeWriter;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="rottencreatures", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeManagerImpl {
    public static void setup() {
    }

    @SubscribeEvent
    public static void event(BiomeLoadingEvent event) {
        BiomeManager.INSTANCE.register(new ForgeBiomeWriter(event));
    }

    static class ForgeBiomeWriter
    extends BiomeWriter {
        private final BiomeLoadingEvent event;

        ForgeBiomeWriter(BiomeLoadingEvent event) {
            this.event = event;
        }

        @Override
        public ResourceLocation name() {
            return this.event.getName();
        }

        @Override
        public BiomeContext context() {
            return new BiomeContext(){
                private final ResourceKey<Biome> resourceKey;
                {
                    this.resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.name());
                }

                @Override
                public boolean is(ResourceKey<Biome> biome) {
                    return this.resourceKey == biome;
                }

                @Override
                public boolean is(TagKey<Biome> tag) {
                    Optional holder;
                    Optional registry;
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server != null && (registry = server.m_206579_().m_6632_(Registry.f_122885_)).isPresent() && (holder = ((Registry)registry.get()).m_203636_(this.resourceKey)).isPresent()) {
                        return ((Holder)holder.get()).m_203656_(tag);
                    }
                    return false;
                }

                @Override
                public boolean is(Biome.BiomeCategory category) {
                    return event.getCategory() == category;
                }
            };
        }

        @Override
        public void addFeature(GenerationStep.Decoration step, Holder<PlacedFeature> feature) {
            this.event.getGeneration().m_204201_(step, feature);
        }

        @Override
        public void addSpawn(MobCategory category, EntityType<?> type, int weight, int minGroup, int maxGroup) {
            this.event.getSpawns().m_48376_(category, new MobSpawnSettings.SpawnerData(type, weight, minGroup, maxGroup));
        }
    }
}

