/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MummyArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;

    public MummyArmorLayer(RenderLayerParent<T, M> parent, A innerModel, A outerModel) {
        super(parent);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public void render(PoseStack matrices, MultiBufferSource source, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        this.renderArmorPiece(matrices, source, entity, EquipmentSlot.CHEST, light, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(matrices, source, entity, EquipmentSlot.LEGS, light, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(matrices, source, entity, EquipmentSlot.FEET, light, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(matrices, source, entity, EquipmentSlot.HEAD, light, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack matrices, MultiBufferSource source, T entity, EquipmentSlot slot, int light, A model) {
        ArmorItem item;
        ItemStack stack = entity.m_6844_(slot);
        Item item2 = stack.m_41720_();
        if (item2 instanceof ArmorItem && (item = (ArmorItem)item2).m_40402_() == slot) {
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            if (model == this.innerModel) {
                ((HumanoidModel)model).f_102814_.f_104201_ = 10.0f;
                ((HumanoidModel)model).f_102813_.f_104201_ = 10.0f;
                ((HumanoidModel)model).f_102810_.f_104201_ = -2.0f;
            } else {
                ((HumanoidModel)model).f_102814_.f_104201_ = 12.0f;
                ((HumanoidModel)model).f_102813_.f_104201_ = 12.0f;
            }
            this.setPartVisibility(model, slot);
            boolean useInnerModel = this.usesInnerModel(slot);
            boolean hasFoil = stack.m_41790_();
            if (item instanceof DyeableArmorItem) {
                DyeableArmorItem dye = (DyeableArmorItem)item;
                int color = dye.m_41121_(stack);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, red, green, blue, null);
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, 1.0f, 1.0f, 1.0f, null);
            }
        }
    }

    protected void setPartVisibility(A model, EquipmentSlot slot) {
        model.m_8009_(false);
        switch (slot) {
            case HEAD: {
                ((HumanoidModel)model).f_102808_.f_104207_ = true;
                ((HumanoidModel)model).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102811_.f_104207_ = true;
                ((HumanoidModel)model).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack matrices, MultiBufferSource source, int light, ArmorItem item, boolean hasFoil, A model, boolean useInnerModel, float red, float green, float blue, @Nullable String overlay) {
        VertexConsumer vertices = ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110431_((ResourceLocation)this.getArmorLocation(item, useInnerModel, overlay)), (boolean)false, (boolean)hasFoil);
        model.m_7695_(matrices, vertices, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private A getArmorModel(EquipmentSlot slot) {
        return this.usesInnerModel(slot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    private ResourceLocation getArmorLocation(ArmorItem armor, boolean legs, @Nullable String overlay) {
        String location = "textures/models/armor/" + armor.m_40401_().m_6082_() + "_layer_" + (legs ? 2 : 1) + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(location, ResourceLocation::new);
    }
}

