/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.platform.common.registry.forge;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemRegistryImpl {
    private static final Object2IntMap<ItemLike> ENTRIES = new Object2IntOpenHashMap();

    public static void registerFuel(ItemLike item, int ticks) {
        ENTRIES.put((Object)item, ticks);
    }

    @SubscribeEvent
    public static void onEvent(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().m_41619_()) {
            return;
        }
        int ticks = ENTRIES.getOrDefault((Object)event.getItemStack().m_41720_(), Integer.MIN_VALUE);
        if (ticks != Integer.MIN_VALUE) {
            event.setBurnTime(ticks);
        }
    }

    public static FoodProperties registerFood(int nutrition, float saturation, boolean meat, boolean alwaysEat, boolean fastFood, Supplier<MobEffectInstance> effect, float probability) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nutrition);
        builder.m_38758_(saturation);
        if (meat) {
            builder.m_38757_();
        }
        if (alwaysEat) {
            builder.m_38765_();
        }
        if (fastFood) {
            builder.m_38766_();
        }
        builder.effect(effect, probability);
        return builder.m_38767_();
    }

    static {
        MinecraftForge.EVENT_BUS.register(ItemRegistryImpl.class);
    }
}

