/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.blocks;

import com.github.teamfusion.rottencreatures.common.entities.PrimedTntBarrel;
import com.github.teamfusion.rottencreatures.mixin.access.FireworkRocketEntityAccessor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TntBarrelBlock
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.f_61361_;

    public TntBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState onState, boolean bl) {
        if (onState.m_60713_(state.m_60734_())) {
            return;
        }
        if (level.m_46753_(pos)) {
            TntBarrelBlock.explode(level, pos, true);
            level.m_7471_(pos, false);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos newPos, boolean bl) {
        if (level.m_46753_(pos)) {
            level.m_7471_(pos, false);
            TntBarrelBlock.explode(level, pos, true);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && !player.m_7500_() && ((Boolean)state.m_61143_((Property)UNSTABLE)).booleanValue()) {
            TntBarrelBlock.explode(level, pos, false);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            PrimedTntBarrel tnt = new PrimedTntBarrel(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, explosion.m_46079_());
            tnt.setFuse((short)(level.f_46441_.m_188503_(tnt.getFuse() / 4) + tnt.getFuse() / 8));
            level.m_7967_((Entity)tnt);
        }
    }

    public static void explode(Level level, BlockPos pos, boolean immediately) {
        TntBarrelBlock.explode(level, pos, null, immediately);
    }

    private static void explode(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        TntBarrelBlock.explode(level, pos, entity, false);
    }

    private static void explode(Level level, BlockPos pos, @Nullable LivingEntity entity, boolean immediately) {
        if (!level.f_46443_) {
            PrimedTntBarrel tnt = new PrimedTntBarrel(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity);
            if (immediately) {
                tnt.setFuse(0);
            }
            level.m_7967_((Entity)tnt);
            level.m_6263_(null, tnt.m_20185_(), tnt.m_20186_(), tnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)entity, GameEvent.f_157776_, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42409_) || stack.m_150930_(Items.f_42613_)) {
            TntBarrelBlock.explode(level, pos, (LivingEntity)player);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            Item item = stack.m_41720_();
            if (!player.m_7500_()) {
                if (stack.m_150930_(Items.f_42409_)) {
                    stack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(hand));
                } else {
                    stack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (stack.m_150930_(Items.f_42688_)) {
            Direction direction = hitResult.m_82434_().m_122424_();
            if (!level.f_46443_) {
                FireworkRocketEntity firework = new FireworkRocketEntity(level, stack, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, true);
                ((FireworkRocketEntityAccessor)firework).setLifetime(80);
                int offset = stack.m_41698_("Fireworks").m_128445_("Flight") - 1;
                firework.m_6686_((double)direction.m_122429_(), (double)direction.m_122430_() + (double)offset * 0.125, (double)direction.m_122431_(), 0.5f, 1.0f);
                level.m_7967_((Entity)firework);
                PrimedTntBarrel tnt = new PrimedTntBarrel(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, (LivingEntity)player);
                tnt.m_20329_((Entity)firework);
                level.m_7967_((Entity)tnt);
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                level.m_6263_(null, tnt.m_20185_(), tnt.m_20186_(), tnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157776_, pos);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos pos = hitResult.m_82425_();
            Entity entity = projectile.m_37282_();
            if (projectile.m_6060_() && projectile.m_142265_(level, pos)) {
                LivingEntity living;
                TntBarrelBlock.explode(level, pos, entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
                level.m_7471_(pos, false);
            }
        }
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNSTABLE});
    }
}

