/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities;

import com.github.teamfusion.rottencreatures.common.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.entities.Zap;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Immortal
extends SpellcasterZombie {
    public static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.m_135353_(Immortal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Immortal(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DASH, (Object)false);
    }

    public boolean isDashing() {
        return (Boolean)this.m_20088_().m_135370_(DASH);
    }

    public void setDashing(boolean dashing) {
        this.m_20088_().m_135381_(DASH, (Object)dashing);
    }

    public boolean m_6162_() {
        return false;
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new SummonLightningGoal());
        this.f_21345_.m_25352_(7, (Goal)new DashingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Zombie>((Mob)this, Zombie.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_26050_.m_6095_() != RCEntityTypes.ZAP.get() && this.f_26050_.m_6095_() != RCEntityTypes.IMMORTAL.get() && this.f_26050_.m_6095_() != EntityType.f_20530_;
            }
        });
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if ((this.f_19797_ + this.m_19879_()) % 1200 == 0) {
            int size;
            MobEffect effect = MobEffects.f_19600_;
            List zaps = this.f_19853_.m_45976_(Zap.class, this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            int n = size = zaps.size() - 1 == -1 ? 0 : zaps.size() - 1;
            if (!(!this.hasPower() || zaps.isEmpty() || this.m_21023_(effect) && this.m_21124_(effect).m_19564_() >= size && this.m_21124_(effect).m_19557_() >= 600)) {
                this.m_7292_(new MobEffectInstance(effect, 1200, size));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_21525_() && this.m_20072_()) {
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            bolt.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_().m_7918_(0, 1, 0)));
            this.f_19853_.m_7967_((Entity)bolt);
            this.m_146870_();
        }
        if (this.isDashing()) {
            this.m_21071_(this.m_20191_(), this.m_20191_());
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hurt = super.m_7327_(entity);
        if (hurt && (this.m_21205_().m_41619_() || this.isDashing()) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            living.m_147207_(new MobEffectInstance(RCMobEffects.CHANNELLED.get(), 140 * (int)modifier), (Entity)this);
            Zap.convertToZap((LivingEntity)this, living);
            if (this.isDashing()) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 16.0f);
            }
        }
        return hurt;
    }

    protected void m_7324_(Entity entity) {
        super.m_7324_(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Zap.convertToZap((LivingEntity)this, living);
        }
        if (this.isDashing()) {
            this.m_7327_(entity);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19306_) {
            this.restoreHealth();
            return false;
        }
        if (source == DamageSource.f_19314_ || Objects.equals(source.m_19385_(), "arrow")) {
            return false;
        }
        if (this.hasPower()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 2));
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.m_7472_(source, lootingMultiplier, allowDrops);
        if (allowDrops) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42713_);
            stack.m_41721_(stack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(stack.m_41776_() - 3, 1))));
            if (this.hasPower()) {
                if (this.f_19796_.m_188501_() <= 0.75f) {
                    stack.m_41663_(this.f_19796_.m_188499_() ? Enchantments.f_44958_ : Enchantments.f_44957_, 1);
                }
                this.m_19983_(stack);
            }
            if (!this.hasPower() && this.f_19796_.m_188501_() <= 0.1f) {
                this.m_19983_(stack);
            }
        }
    }

    public boolean hasPower() {
        return this.f_19853_.m_46470_();
    }

    public void restoreHealth() {
        this.m_21153_(this.m_21233_());
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
    }

    class SummonLightningGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonLightningGoal() {
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel level = (ServerLevel)Immortal.this.f_19853_;
            if (Immortal.this.f_19796_.m_188499_()) {
                for (int i = 0; i <= Immortal.this.f_19796_.m_188503_(2); ++i) {
                    BlockPos pos = Immortal.this.m_20183_().m_7918_(-4 + Immortal.this.f_19796_.m_188503_(9), 0, -4 + Immortal.this.f_19796_.m_188503_(9));
                    LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(Immortal.this.f_19853_);
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    level.m_7967_((Entity)bolt);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return Immortal.this.m_21223_() <= Immortal.this.m_21233_() / 100.0f * 80.0f && Immortal.this.hasPower() && Immortal.this.f_19853_.m_45527_(Immortal.this.m_20183_()) && Immortal.this.f_19796_.m_188499_();
        }

        @Override
        protected int getCastingTime() {
            return 0;
        }

        @Override
        protected int getCastingInterval() {
            return Immortal.this.m_21223_() <= Immortal.this.m_21233_() / 100.0f * 40.0f ? 800 : 1600;
        }
    }

    class DashingGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final Immortal immortal;

        DashingGoal(Immortal immortal) {
            this.immortal = immortal;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.immortal.setDashing(true);
        }

        @Override
        protected void performSpellCasting() {
            float zRot = this.immortal.m_6080_();
            float xRot = this.immortal.m_146909_();
            float modifier = (float)Math.PI / 180;
            float x = -Mth.m_14031_((float)(zRot * modifier)) * Mth.m_14089_((float)(xRot * modifier));
            float y = -Mth.m_14031_((float)(xRot * modifier));
            float z = Mth.m_14089_((float)(zRot * modifier)) * Mth.m_14089_((float)(xRot * modifier));
            float range = Mth.m_14116_((float)(x * x + y * y + z * z));
            float power = 4.0f;
            this.immortal.m_5997_(x *= power / range, y *= power / range, z *= power / range);
            this.immortal.f_20938_ = 30;
            if (!this.immortal.f_19853_.f_46443_) {
                this.immortal.m_21155_(4, true);
            }
            if (this.immortal.m_20096_()) {
                this.immortal.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            this.immortal.f_19853_.m_6269_(null, (Entity)this.immortal, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.immortal.f_19853_.m_6269_(null, (Entity)this.immortal, SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            Immortal.this.m_21071_(Immortal.this.m_20191_(), Immortal.this.m_20191_());
        }

        public void m_8041_() {
            super.m_8041_();
            this.immortal.setDashing(false);
            this.immortal.restoreHealth();
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.immortal.m_5448_() != null ? this.immortal.m_5448_() : null;
            return target != null && this.immortal.m_20270_((Entity)target) > 8.0f && super.m_8036_() && this.immortal.hasPower();
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 640;
        }
    }
}

